/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.combo;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.ui.combo.ICombo;

public abstract class ACombo
implements ICombo {
    protected List<ISelectionListener> selectionListeners;
    protected Object[] options = new Object[0];
    protected ICombo.ILabelGetter labelGetter;
    protected int selectionIndex = -1;

    @Override
    public void setOptions(Object[] options) {
        this.options = options;
        this.selectionIndex = -1;
    }

    @Override
    public void setLabelGetter(ICombo.ILabelGetter labelGetter) {
        this.labelGetter = labelGetter;
    }

    public void addSelectionListener(ISelectionListener selectionListener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<ISelectionListener>();
        }
        this.selectionListeners.add(selectionListener);
    }

    public List<ISelectionListener> getSelectionListeners() {
        return this.selectionListeners;
    }

    protected void notifySelectionChanged(int selectionIndex) {
        this.selectionIndex = selectionIndex;
        if (this.selectionListeners == null) {
            return;
        }
        Object option = this.getSelection();
        for (ISelectionListener listener : this.selectionListeners) {
            listener.selectionChanged(option);
        }
    }

    @Override
    public Object getSelection() {
        Object option = null;
        if (this.selectionIndex >= 0 && this.selectionIndex < this.options.length) {
            option = this.options[this.selectionIndex];
        }
        return option;
    }

    @Override
    public int getSelectionIndex() {
        return this.selectionIndex;
    }

    @Override
    public void setSelectionIndex(int index) {
        this.selectionIndex = index;
    }

    @Override
    public void setSelection(Object option) {
        int index;
        this.selectionIndex = index = -1;
        Object[] objectArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o == option) {
                this.selectionIndex = index;
            }
            ++index;
            ++n2;
        }
    }

    @Override
    public void clearOptions() {
        this.options = new Object[0];
        this.selectionIndex = -1;
    }

    @Override
    public void addOption(Object option) {
        Object[] newOptions = new Object[this.options.length + 1];
        int index = 0;
        Object[] objectArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            Object old;
            newOptions[index] = old = objectArray[n2];
            ++index;
            ++n2;
        }
        newOptions[index] = option;
        this.options = newOptions;
    }

    public static interface ISelectionListener {
        public void selectionChanged(Object var1);
    }
}

