/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.diagram;

import java.util.ArrayList;
import java.util.List;
import jsinterop.annotations.JsMethod;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.core.diagram.Rect;
import net.edgemind.ibee.core.diagram.Symbol;
import net.edgemind.ibee.core.util.Selection;
import net.edgemind.ibee.ui.app.IComponent;
import net.edgemind.ibee.ui.common.listener.IKeyPressedListener;
import net.edgemind.ibee.ui.common.listener.IKeyReleaseListener;
import net.edgemind.ibee.ui.common.listener.IMouseClickedListener;
import net.edgemind.ibee.ui.common.listener.IMouseDblClickListener;
import net.edgemind.ibee.ui.common.listener.IMouseDownListener;
import net.edgemind.ibee.ui.common.listener.IMouseMoveListener;
import net.edgemind.ibee.ui.common.listener.IMouseScrollListener;
import net.edgemind.ibee.ui.common.listener.IMouseTraverseListener;
import net.edgemind.ibee.ui.common.listener.IMouseUpListener;
import net.edgemind.ibee.ui.common.listener.IResizedListener;
import net.edgemind.ibee.ui.diagram.CURSOR;
import net.edgemind.ibee.ui.diagram.IDiagramPaintListener;
import net.edgemind.ibee.ui.diagram.MouseButton;
import net.edgemind.ibee.ui.diagram.OverlayProvider;
import net.edgemind.ibee.ui.diagram.renderer.IDiagramRenderer;
import net.edgemind.ibee.ui.menu.IMenuProvider;
import net.edgemind.ibee.ui.menu.IMenuRenderer;
import net.edgemind.ibee.ui.toolbar.IToolbar;
import net.edgemind.ibee.ui.toolbar.IToolbarProvider;
import net.edgemind.ibee.ui.toolbar.ToolbarFactory;
import net.edgemind.ibee.ui.toolbar.ToolbarPanel;
import net.edgemind.ibee.util.math.Frame;

public abstract class DiagramPanel
implements IComponent {
    Group paperSizeGroup = null;
    Group gridGroup = null;
    protected CURSOR lastCursor = CURSOR.ARROW;
    protected List<IMouseDownListener> mouseDownListeners;
    protected List<IMouseUpListener> mouseUpListeners;
    protected List<IMouseMoveListener> mouseMoveListeners;
    protected List<IMouseScrollListener> mouseScrollListeners;
    protected List<IMouseClickedListener> mouseClickedListeners;
    protected List<IKeyPressedListener> keyPressedListeners;
    protected List<IKeyReleaseListener> keyReleasedListeners;
    protected List<IResizedListener> resizedListeners;
    protected List<IMouseTraverseListener> traverseListeners;
    protected List<IMouseDblClickListener> mouseDblClickListeners;
    protected List<IDiagramPaintListener> repaintListeners;
    protected List<IToolbarProvider> toolbarProviders1;
    protected List<IToolbarProvider> toolbarProviders2;
    protected List<OverlayProvider> overlayProviders;
    protected List<IMenuProvider> menuProviders;
    private boolean horizontalScrollbarEnabled = false;
    private boolean verticalScrollbarEnabled = false;
    private boolean toolbarEnabled = false;
    private boolean contextMenuEnabled = false;
    protected Frame scrollableFrame = null;
    protected Diagram diagram;
    protected List<Group> overlays;
    protected ToolbarPanel toolbarPanel1;
    protected ToolbarPanel toolbarPanel2;
    protected IToolbar toolbar1;
    protected IToolbar toolbar2;
    double minZoom = -1.0;
    double maxZoom = -1.0;
    protected Point dpi = new Point(100.0, 100.0);
    protected double zoomX = 1.0;
    protected double zoomY = 1.0;
    protected double translateX = 0.0;
    protected double translateY = 0.0;
    protected boolean tanslateToCenterX = true;
    protected boolean tanslateToCenterY = true;
    protected PAPERSIZE paperSize = PAPERSIZE.NONE;
    protected Color paperColor = Color.WHITE;
    protected Color backgroundColor = Color.WHITE;
    protected Point cursorPos = new Point();
    protected boolean gridActivated = false;
    protected int gridWidth = 1;
    protected int gridHeight = 1;

    public abstract double getClientWidth();

    public abstract double getClientHeight();

    public abstract IDiagramRenderer getDiagramRenderer();

    public abstract ToolbarPanel createToolbarPanel1();

    public abstract ToolbarPanel createToolbarPanel2();

    public abstract IMenuRenderer getMenuRenderer();

    protected abstract void createContents();

    protected abstract void showCursor(CURSOR var1);

    protected abstract void setVerticalScroll(double var1, double var3);

    protected abstract void setHorizontalScroll(double var1, double var3);

    public void create() {
        this.createContents();
        if (this.getToolbarEnabled()) {
            this.toolbarPanel1 = this.createToolbarPanel1();
            this.toolbarPanel2 = this.createToolbarPanel2();
            this.renderToolbar1();
            this.renderToolbar2();
        }
    }

    public void addMouseDownListener(IMouseDownListener listener) {
        if (this.mouseDownListeners == null) {
            this.mouseDownListeners = new ArrayList<IMouseDownListener>();
        }
        this.mouseDownListeners.add(listener);
    }

    protected void mouseDown(double x, double y, MouseButton btn) {
        this.cursorPos = new Point(x, y);
        if (this.mouseDownListeners == null) {
            return;
        }
        for (IMouseDownListener listener : this.mouseDownListeners) {
            listener.mouseDown(x, y, btn);
        }
    }

    public void addMouseClickListener(IMouseClickedListener listener) {
        if (this.mouseClickedListeners == null) {
            this.mouseClickedListeners = new ArrayList<IMouseClickedListener>();
        }
        this.mouseClickedListeners.add(listener);
    }

    public void mouseClick(double x, double y, MouseButton btn) {
        this.cursorPos = new Point(x, y);
        if (this.mouseClickedListeners == null) {
            return;
        }
        for (IMouseClickedListener listener : this.mouseClickedListeners) {
            listener.mouseClicked(x, y, btn);
        }
    }

    public void addMouseUpListener(IMouseUpListener listener) {
        if (this.mouseUpListeners == null) {
            this.mouseUpListeners = new ArrayList<IMouseUpListener>();
        }
        this.mouseUpListeners.add(listener);
    }

    protected void mouseUp(double x, double y, MouseButton btn) {
        if (this.mouseUpListeners == null) {
            return;
        }
        for (IMouseUpListener listener : this.mouseUpListeners) {
            listener.mouseUp(x, y, btn);
        }
    }

    public void addMouseMoveListener(IMouseMoveListener listener) {
        if (this.mouseMoveListeners == null) {
            this.mouseMoveListeners = new ArrayList<IMouseMoveListener>();
        }
        this.mouseMoveListeners.add(listener);
    }

    protected void mouseMove(double x, double y) {
        if (this.mouseMoveListeners == null) {
            return;
        }
        for (IMouseMoveListener listener : this.mouseMoveListeners) {
            listener.mouseMove(x, y);
        }
    }

    public void addMouseTraverseListener(IMouseTraverseListener listener) {
        if (this.traverseListeners == null) {
            this.traverseListeners = new ArrayList<IMouseTraverseListener>();
        }
        this.traverseListeners.add(listener);
    }

    protected void mouseTraverseIn() {
        if (this.traverseListeners == null) {
            return;
        }
        for (IMouseTraverseListener listener : this.traverseListeners) {
            listener.movedIn();
        }
    }

    protected void mouseTraverseOut() {
        if (this.traverseListeners == null) {
            return;
        }
        for (IMouseTraverseListener listener : this.traverseListeners) {
            listener.movedOut();
        }
    }

    public void addMouseScrollListener(IMouseScrollListener listener) {
        if (this.mouseScrollListeners == null) {
            this.mouseScrollListeners = new ArrayList<IMouseScrollListener>();
        }
        this.mouseScrollListeners.add(listener);
    }

    protected void mouseScroll(int count) {
        if (this.mouseScrollListeners == null) {
            return;
        }
        for (IMouseScrollListener listener : this.mouseScrollListeners) {
            listener.mouseScroll(count);
        }
    }

    public void addKeyPressedListener(IKeyPressedListener listener) {
        if (this.keyPressedListeners == null) {
            this.keyPressedListeners = new ArrayList<IKeyPressedListener>();
        }
        this.keyPressedListeners.add(listener);
    }

    protected void keyPress(int keycode) {
        if (this.keyPressedListeners == null) {
            return;
        }
        for (IKeyPressedListener listener : this.keyPressedListeners) {
            listener.keyPressed(keycode);
        }
    }

    public void addKeyReleaseListener(IKeyReleaseListener listener) {
        if (this.keyReleasedListeners == null) {
            this.keyReleasedListeners = new ArrayList<IKeyReleaseListener>();
        }
        this.keyReleasedListeners.add(listener);
    }

    protected void keyRelease(int keycode) {
        if (this.keyReleasedListeners == null) {
            return;
        }
        for (IKeyReleaseListener listener : this.keyReleasedListeners) {
            listener.keyReleased(keycode);
        }
    }

    public void addDiagramPaintListener(IDiagramPaintListener l) {
        if (this.repaintListeners == null) {
            this.repaintListeners = new ArrayList<IDiagramPaintListener>();
        }
        this.repaintListeners.add(l);
    }

    public void addResizedListener(IResizedListener listener) {
        if (this.resizedListeners == null) {
            this.resizedListeners = new ArrayList<IResizedListener>();
        }
        this.resizedListeners.add(listener);
    }

    public void addDoubleClickListener(IMouseDblClickListener listener) {
        if (this.mouseDblClickListeners == null) {
            this.mouseDblClickListeners = new ArrayList<IMouseDblClickListener>();
        }
        this.mouseDblClickListeners.add(listener);
    }

    public void doubleClick(double x, double y, MouseButton btn) {
        if (this.mouseDblClickListeners == null) {
            return;
        }
        for (IMouseDblClickListener listener : this.mouseDblClickListeners) {
            listener.doubleClicked(x, y, btn);
        }
    }

    protected void resized(double width, double height) {
        if (this.resizedListeners == null) {
            return;
        }
        for (IResizedListener listener : this.resizedListeners) {
            listener.resized(width, height);
        }
    }

    public void setZoom(double value) {
        this.setZoomX(value);
        this.setZoomY(value);
    }

    public void setZoomX(double value) {
        if (this.minZoom >= 0.0 && value < this.minZoom) {
            value = this.minZoom;
        }
        if (this.maxZoom >= 0.0 && value > this.maxZoom) {
            value = this.maxZoom;
        }
        this.zoomX = value;
    }

    public void setZoomY(double value) {
        this.zoomY = value;
    }

    public void setTranslateX(double value) {
        this.translateX = value;
    }

    public void setTranslateY(double value) {
        this.translateY = value;
    }

    public double getZoomX() {
        return this.zoomX;
    }

    public double getZoomXIntern() {
        return this.zoomX;
    }

    public double getZoomYIntern() {
        return this.zoomY;
    }

    public double getZoomY() {
        return this.zoomY;
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public double getTranslateY() {
        return this.translateY;
    }

    @JsMethod
    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public void createPaper() {
        if (this.diagram == null) {
            return;
        }
        if (this.paperSizeGroup == null) {
            this.paperSizeGroup = new Group();
        }
        if (!this.diagram.getGroups().contains(this.paperSizeGroup)) {
            this.diagram.getGroups().add(0, this.paperSizeGroup);
        }
        this.paperSizeGroup.clear();
        if (this.paperSize != PAPERSIZE.NONE) {
            Node node;
            if (this.paperSize == PAPERSIZE.DIN_A4) {
                node = new Node();
                node.setX(0.0);
                node.setY(0.0);
                node.setWidth(8.27 * this.getDPI().getX());
                node.setHeight(11.69 * this.getDPI().getY());
                node.setForeColor(Color.BLACK);
                node.setSymbol((Symbol)new Rect());
                node.setBackColor(this.paperColor);
                this.paperSizeGroup.addNode(node);
            }
            if (this.paperSize == PAPERSIZE.DIN_A3) {
                node = new Node();
                node.setX(0.0);
                node.setY(0.0);
                node.setWidth(11.69 * this.getDPI().getX());
                node.setHeight(16.53 * this.getDPI().getY());
                node.setForeColor(Color.BLACK);
                node.setSymbol((Symbol)new Rect());
                node.setBackColor(this.paperColor);
                this.paperSizeGroup.addNode(node);
            }
            if (this.paperSize == PAPERSIZE.DIN_A4_LANDSCAPE) {
                node = new Node();
                node.setX(0.0);
                node.setY(0.0);
                node.setWidth(11.69 * this.getDPI().getX());
                node.setHeight(8.27 * this.getDPI().getY());
                node.setForeColor(Color.BLACK);
                node.setSymbol((Symbol)new Rect());
                node.setBackColor(this.paperColor);
                this.paperSizeGroup.addNode(node);
            }
            if (this.paperSize == PAPERSIZE.DIN_A3_LANDSCAPE) {
                node = new Node();
                node.setX(0.0);
                node.setY(0.0);
                node.setWidth(16.53 * this.getDPI().getX());
                node.setHeight(11.69 * this.getDPI().getY());
                node.setForeColor(Color.BLACK);
                node.setSymbol((Symbol)new Rect());
                node.setBackColor(this.paperColor);
                this.paperSizeGroup.addNode(node);
            }
        }
    }

    public void createGrid() {
        if (this.diagram == null) {
            return;
        }
        if (this.gridGroup == null) {
            this.gridGroup = new Group();
        }
        if (!this.diagram.getGroups().contains(this.gridGroup)) {
            this.diagram.getGroups().add(0, this.gridGroup);
        }
        this.gridGroup.clear();
        if (this.gridActivated) {
            Edge edge;
            Point point2;
            Point point1;
            ArrayList<Point> points;
            Edge edge2;
            Point point22;
            Point point12;
            ArrayList<Point> points2;
            Frame visibleFrame = this.getVisibleFrame();
            double xMin = visibleFrame.getX();
            double xMax = visibleFrame.getX() + visibleFrame.getWidth();
            double yMin = visibleFrame.getY();
            double yMax = visibleFrame.getY() + visibleFrame.getHeight();
            double zoomX = this.getZoomX();
            int width = (int)((double)this.gridWidth / zoomX) - (int)((double)this.gridWidth / zoomX) % this.gridWidth;
            if (width < this.gridWidth) {
                width = this.gridWidth;
            }
            int height = width;
            double rest = yMin % (double)height;
            yMin = yMin - rest - (double)height;
            rest = yMax % (double)height;
            yMax = yMax - rest + (double)height;
            int i = 0;
            while ((double)(i * width) < xMax) {
                points2 = new ArrayList<Point>();
                point12 = new Point((double)(i * width), yMin);
                point22 = new Point((double)(i * width), yMax);
                points2.add(point12);
                points2.add(point22);
                edge2 = new Edge();
                edge2.setPoints(points2);
                edge2.setForeColor(Color.GRAY);
                edge2.setBackColor(Color.GRAY);
                this.gridGroup.addEdge(edge2);
                ++i;
            }
            i = -1;
            while ((double)(i * width) > xMin) {
                points2 = new ArrayList();
                point12 = new Point((double)(i * width), yMin);
                point22 = new Point((double)(i * width), yMax);
                points2.add(point12);
                points2.add(point22);
                edge2 = new Edge();
                edge2.setPoints(points2);
                edge2.setForeColor(Color.GRAY);
                edge2.setBackColor(Color.GRAY);
                this.gridGroup.addEdge(edge2);
                --i;
            }
            int j = 0;
            while ((double)(j * width) < yMax) {
                points = new ArrayList<Point>();
                point1 = new Point(xMin, (double)(j * width));
                point2 = new Point(xMax, (double)(j * width));
                points.add(point1);
                points.add(point2);
                edge = new Edge();
                edge.setPoints(points);
                edge.setForeColor(Color.GRAY);
                edge.setBackColor(Color.GRAY);
                this.gridGroup.addEdge(edge);
                ++j;
            }
            j = -1;
            while ((double)(j * width) > yMin) {
                points = new ArrayList();
                point1 = new Point(xMin, (double)(j * width));
                point2 = new Point(xMax, (double)(j * width));
                points.add(point1);
                points.add(point2);
                edge = new Edge();
                edge.setPoints(points);
                edge.setForeColor(Color.GRAY);
                edge.setBackColor(Color.GRAY);
                this.gridGroup.addEdge(edge);
                --j;
            }
        }
    }

    public void paintDiagram() {
        this.getDiagramRenderer().setTranslate(this.translateX, this.translateY);
        this.getDiagramRenderer().setZoomX(this.zoomX);
        this.getDiagramRenderer().setZoomY(this.zoomY);
        this.getDiagramRenderer().translateToCenterX(this.tanslateToCenterX);
        this.getDiagramRenderer().translateToCenterY(this.tanslateToCenterY);
        Frame visibleFrame = this.getVisibleFrame();
        this.getDiagramRenderer().setVisibleFrame(visibleFrame);
        if (this.repaintListeners != null) {
            for (IDiagramPaintListener listener : this.repaintListeners) {
                listener.repaintDiagramPre(this.diagram);
            }
        }
        this.createGrid();
        this.createPaper();
        this.getDiagramRenderer().setBackgroundColor(this.backgroundColor);
        this.getDiagramRenderer().repaintDiagram(this.diagram);
        if (this.repaintListeners != null) {
            for (IDiagramPaintListener listener : this.repaintListeners) {
                listener.repaintDiagramPost(this.diagram);
            }
        }
        this.paintOverlay();
    }

    public void addOverlay(Group group) {
        if (this.overlays == null) {
            this.overlays = new ArrayList<Group>();
        }
        this.overlays.add(group);
    }

    public void removeOverlay(Group group) {
        if (this.overlays == null) {
            return;
        }
        this.overlays.remove(group);
    }

    public void paintOverlay() {
        Group overlay = new Group();
        if (this.overlayProviders != null) {
            for (OverlayProvider provider : this.overlayProviders) {
                Group group = provider.paintOverlay(this.diagram);
                if (group == null) continue;
                overlay.addGroup(group);
            }
        }
        if (this.overlays != null) {
            for (Group group : this.overlays) {
                if (group == null) continue;
                overlay.addGroup(group);
            }
        }
        if (this.repaintListeners != null) {
            for (IDiagramPaintListener listener : this.repaintListeners) {
                listener.repaintOverlayPre(overlay);
            }
        }
        this.getDiagramRenderer().paintOverlay(overlay);
        if (this.repaintListeners != null) {
            for (IDiagramPaintListener listener : this.repaintListeners) {
                listener.repaintOverlayPost(overlay);
            }
        }
    }

    public double detranslateX(double x) {
        if (this.tanslateToCenterX) {
            double clientWidth = this.getClientWidth();
            return (x - this.translateX) * this.zoomX + clientWidth / 2.0;
        }
        return (x - this.translateX) * this.zoomX;
    }

    public double detranslateY(double y) {
        if (this.tanslateToCenterY) {
            double clientHeight = this.getClientHeight();
            return (y - this.translateY) * this.zoomY + clientHeight / 2.0;
        }
        return (y - this.translateY) * this.zoomY;
    }

    public double translateX(double x) {
        if (this.tanslateToCenterX) {
            double clientWidth = this.getClientWidth();
            return (x - clientWidth / 2.0) / this.zoomX + this.translateX;
        }
        return x / this.zoomX + this.translateX;
    }

    public double translateY(double y) {
        if (this.tanslateToCenterY) {
            double clientHeight = this.getClientHeight();
            return (y - clientHeight / 2.0) / this.zoomY + this.translateY;
        }
        return y / this.zoomY + this.translateY;
    }

    public Frame translate(Frame frame) {
        Frame result = new Frame(this.translateX(frame.getX()), this.translateY(frame.getY()), frame.getWidth() / this.zoomX, frame.getHeight() / this.zoomY);
        return result;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    @Override
    @JsMethod
    public void refreshPage() {
        this.paintDiagram();
    }

    @Override
    public void setSelection(Selection<Object> selection) {
        List selectedElements = selection.getElements();
        if (this.getDiagramRenderer().getSelectedElements().equals(selectedElements)) {
            return;
        }
        this.getDiagramRenderer().setSelectedElements(selectedElements);
    }

    public void setCursor(CURSOR cursor) {
        if (this.lastCursor == cursor) {
            return;
        }
        this.lastCursor = cursor;
        this.showCursor(cursor);
    }

    public boolean translateToCenterX() {
        return this.tanslateToCenterX;
    }

    public boolean translateToCenterY() {
        return this.tanslateToCenterY;
    }

    public void translateToCenterX(boolean value) {
        this.tanslateToCenterX = value;
    }

    public void translateToCenterY(boolean value) {
        this.tanslateToCenterY = value;
    }

    public void adaptScrollBars(boolean correct) {
        Frame frame = this.getDiagramFrame();
        if (this.diagram == null || frame == null) {
            if (this.horizontalScrollbarEnabled) {
                this.setHorizontalScroll(0.0, 0.0);
            }
            if (this.verticalScrollbarEnabled) {
                this.setVerticalScroll(0.0, 0.0);
            }
            return;
        }
        double minx = frame.getX();
        double maxx = frame.getX() + frame.getWidth();
        double miny = frame.getY();
        double maxy = frame.getY() + frame.getHeight();
        if (maxx < minx) {
            maxx = minx;
        }
        if (maxy < miny) {
            maxy = miny;
        }
        double currentX = this.getTranslateX();
        double currentY = this.getTranslateY();
        if (this.getTranslateX() < minx) {
            currentX = minx;
            if (correct) {
                this.setTranslateX(minx);
            }
        }
        if (this.getTranslateX() > maxx) {
            currentX = maxx;
            if (correct) {
                this.setTranslateX(maxx);
            }
        }
        if (this.getTranslateY() < miny) {
            currentY = miny;
            if (correct) {
                this.setTranslateY(miny);
            }
        }
        if (this.getTranslateY() > maxy) {
            currentY = maxy;
            if (correct) {
                this.setTranslateY(maxy);
            }
        }
        if (this.horizontalScrollbarEnabled) {
            double scrollXCurrent = (currentX - minx) * this.getZoomX();
            double scrollXWidth = (maxx - minx) * this.getZoomX();
            this.setHorizontalScroll(scrollXCurrent, scrollXWidth);
        }
        if (this.verticalScrollbarEnabled) {
            double scrollYCurrent = (currentY - miny) * this.getZoomY();
            double scrollYWidth = (maxy - miny) * this.getZoomY();
            this.setVerticalScroll(scrollYCurrent, scrollYWidth);
        }
    }

    public void setScrollableFrame(Frame frame) {
        this.scrollableFrame = frame;
    }

    @JsMethod
    public void setHorizontalScrollbarEnabled(boolean value) {
        this.horizontalScrollbarEnabled = value;
    }

    public boolean getHorizontalScrollbarEnabled() {
        return this.horizontalScrollbarEnabled;
    }

    @JsMethod
    public void setVerticalScrollbarEnabled(boolean value) {
        this.verticalScrollbarEnabled = value;
    }

    public boolean getVerticalScrollbarEnabled() {
        return this.verticalScrollbarEnabled;
    }

    @JsMethod
    public void setToolbarEnabled(boolean value) {
        this.toolbarEnabled = value;
    }

    public boolean getToolbarEnabled() {
        return this.toolbarEnabled;
    }

    public void setContextMenuEnabled(boolean value) {
        this.contextMenuEnabled = value;
    }

    public boolean getContextMenuEnabled() {
        return this.contextMenuEnabled;
    }

    public Point getDPI() {
        return this.dpi;
    }

    public void setDPI(Point dpi) {
        this.dpi = dpi;
    }

    public Point getDisplayDPI() {
        return new Point(253.99986284007406, 253.99986284007406);
    }

    public Frame getDiagramFrame() {
        Point dpi;
        Frame frame = this.scrollableFrame;
        if (this.scrollableFrame == null && this.diagram != null) {
            frame = this.diagram.getSize(false);
        }
        if (frame == null) {
            frame = new Frame();
        }
        if (this.paperSize == PAPERSIZE.DIN_A3) {
            dpi = this.getDPI();
            frame.expand(new Frame(0.0, 0.0, 11.69 * dpi.getX(), 16.53 * dpi.getY()));
        }
        if (this.paperSize == PAPERSIZE.DIN_A4) {
            dpi = this.getDPI();
            frame.expand(new Frame(0.0, 0.0, 8.27 * dpi.getX(), 11.69 * dpi.getY()));
        }
        if (this.paperSize == PAPERSIZE.DIN_A3_LANDSCAPE) {
            dpi = this.getDPI();
            frame.expand(new Frame(0.0, 0.0, 16.53 * dpi.getX(), 11.69 * dpi.getY()));
        }
        if (this.paperSize == PAPERSIZE.DIN_A4_LANDSCAPE) {
            dpi = this.getDPI();
            frame.expand(new Frame(0.0, 0.0, 11.69 * dpi.getX(), 8.27 * dpi.getY()));
        }
        return frame;
    }

    public Frame getVisibleFrame() {
        Frame frame = new Frame();
        frame.setX(this.translateX(0.0));
        frame.setY(this.translateY(0.0));
        frame.setWidth(this.translateX(this.getClientWidth()) - frame.getX());
        frame.setHeight(this.translateY(this.getClientHeight()) - frame.getY());
        frame.setInvalid(false);
        return frame;
    }

    public void center(double diagramX, double diagramY) {
        this.translateX = diagramX;
        this.translateY = diagramY;
    }

    public void resetZoom() {
        this.setZoom(1.0);
    }

    public void center(boolean keepRatio) {
        Frame diagramFrame = this.getDiagramFrame();
        if (diagramFrame == null) {
            return;
        }
        Frame frame = new Frame();
        frame.copy(diagramFrame);
        if (frame.getHeight() < 100.0) {
            frame.setHeight(100.0);
        }
        if (frame.getWidth() < 100.0) {
            frame.setWidth(100.0);
        }
        this.zoomX = this.getClientWidth() / frame.getWidth();
        this.zoomY = this.getClientHeight() / frame.getHeight();
        if (keepRatio) {
            if (this.zoomX < this.zoomY) {
                this.zoomY = this.zoomX;
            } else {
                this.zoomX = this.zoomY;
            }
        }
        this.translateX = frame.getX() + frame.getWidth() / 2.0;
        this.translateY = frame.getY() + frame.getHeight() / 2.0;
    }

    public void renderToolbar1() {
        if (!this.getToolbarEnabled()) {
            return;
        }
        if (this.toolbarProviders1 == null) {
            return;
        }
        if (this.toolbar1 == null) {
            this.toolbar1 = ToolbarFactory.createToolbar();
        } else {
            this.toolbar1.clear();
        }
        for (IToolbarProvider provider : this.toolbarProviders1) {
            IToolbar next = provider.create();
            if (next == null) continue;
            this.toolbar1.addItems(next.getItems());
        }
        this.toolbarPanel1.getToolbarRenderer().renderToolBar(this.toolbar1);
    }

    public void renderToolbar2() {
        if (!this.getToolbarEnabled()) {
            return;
        }
        if (this.toolbarProviders2 == null) {
            return;
        }
        if (this.toolbar2 == null) {
            this.toolbar2 = ToolbarFactory.createToolbar();
        } else {
            this.toolbar2.clear();
        }
        for (IToolbarProvider provider : this.toolbarProviders2) {
            IToolbar next = provider.create();
            if (next == null) continue;
            this.toolbar2.addItems(next.getItems());
        }
        this.toolbarPanel2.getToolbarRenderer().renderToolBar(this.toolbar2);
    }

    public void addToolbarProvider1(IToolbarProvider provider) {
        if (this.toolbarProviders1 == null) {
            this.toolbarProviders1 = new ArrayList<IToolbarProvider>();
        }
        this.toolbarProviders1.add(provider);
    }

    public void addToolbarProvider2(IToolbarProvider provider) {
        if (this.toolbarProviders2 == null) {
            this.toolbarProviders2 = new ArrayList<IToolbarProvider>();
        }
        this.toolbarProviders2.add(provider);
    }

    public void addMenuProvider(IMenuProvider provider) {
        if (this.menuProviders == null) {
            this.menuProviders = new ArrayList<IMenuProvider>();
        }
        this.menuProviders.add(provider);
    }

    public void addOverlayProvider(OverlayProvider provider) {
        if (this.overlayProviders == null) {
            this.overlayProviders = new ArrayList<OverlayProvider>();
        }
        this.overlayProviders.add(provider);
    }

    public IToolbar getToolbar1() {
        if (this.toolbar1 == null) {
            this.toolbar1 = ToolbarFactory.createToolbar();
        }
        return this.toolbar1;
    }

    public IToolbar getToolbar2() {
        if (this.toolbar2 == null) {
            this.toolbar2 = ToolbarFactory.createToolbar();
        }
        return this.toolbar2;
    }

    public Point getCursorPos(boolean inDiagramCoord) {
        if (inDiagramCoord) {
            return new Point(this.translateX(this.cursorPos.getX()), this.translateY(this.cursorPos.getY()));
        }
        return this.cursorPos;
    }

    public void setPaperSize(PAPERSIZE size) {
        this.paperSize = size;
    }

    public PAPERSIZE getPaperSize() {
        return this.paperSize;
    }

    public void setGrid(boolean gridActivated) {
        if (!gridActivated) {
            this.setGridWidth(1);
            this.setGridHeight(1);
        }
        this.gridActivated = gridActivated;
    }

    public boolean getGrid() {
        return this.gridActivated;
    }

    public void setGridWidth(int gridWidth) {
        this.gridWidth = gridWidth;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridHeight(int gridHeight) {
        this.gridHeight = gridHeight;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setPaperColor(Color color) {
        this.paperColor = color;
    }

    public Color getPaperColor() {
        return this.paperColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setMaxZoom(double value) {
        this.maxZoom = value;
    }

    public void setMinZoom(double value) {
        this.minZoom = value;
    }

    public double getMinZoom() {
        return this.minZoom;
    }

    public double getMaxZoom() {
        return this.maxZoom;
    }

    public static enum PAPERSIZE {
        NONE,
        DIN_A4,
        DIN_A3,
        DIN_A4_LANDSCAPE,
        DIN_A3_LANDSCAPE;

    }
}

