/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.diagram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.edgemind.ibee.core.diagram.DElement;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.core.diagram.Text;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.util.math.Frame;
import net.edgemind.ibee.util.math.Line;
import net.edgemind.ibee.util.math.MathUtil;
import net.edgemind.ibee.util.math.Point2D;

public class DiagramUtil {
    public static DElement getSelectedDiagramElement(Diagram diagram, double x, double y) {
        return DiagramUtil.getSelectedDiagramElement(diagram, x, y, 1.0, 1.0);
    }

    public static DElement getSelectedDiagramElement(Diagram diagram, double x, double y, double zoomX, double zoomY) {
        Edge selected = DiagramUtil.getSelectedEdge(diagram, x, y, zoomX, zoomY);
        if (selected == null) {
            selected = DiagramUtil.getSelectedText(diagram, x, y, zoomX, zoomY);
        }
        if (selected == null) {
            selected = DiagramUtil.getSelectedNode(diagram, x, y, zoomX, zoomY);
        }
        return selected;
    }

    public static Edge getSelectedEdge(Diagram diagram, double x, double y) {
        return DiagramUtil.getSelectedEdge(diagram, x, y, 1.0, 1.0);
    }

    public static Edge getSelectedEdge(Diagram diagram, double x, double y, double zoomX, double zoomY) {
        if (diagram == null) {
            return null;
        }
        for (Group group : diagram.getGroups()) {
            Edge test = DiagramUtil.getSelectedEdge(group, x, y, zoomX, zoomY);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    public static Edge getSelectedEdge(Group group, double x, double y, double zoomX, double zoomY) {
        for (Edge e : group.getEdges()) {
            double d;
            if (e.getElement() == null) continue;
            List<Point> points = DiagramUtil.getEdgePoints(e);
            if (e.getLineAlgo() == Edge.LineAlgo.BEZIER) {
                Point2D[] curve = new Point2D[points.size()];
                int index = 0;
                for (Point p : points) {
                    Point2D point2d;
                    curve[index] = point2d = new Point2D(p.getX() * zoomX, p.getY() * zoomY);
                    ++index;
                }
                d = MathUtil.getBezierDistance((Point2D)new Point2D(x * zoomX, y * zoomY), (Point2D[])curve);
                if (d < 5.0) {
                    return e;
                }
            }
            int i = 1;
            while (i < points.size()) {
                Line line = new Line(points.get(i - 1).getX() * zoomX, points.get(i - 1).getY() * zoomY, points.get(i).getX() * zoomX, points.get(i).getY() * zoomY);
                d = MathUtil.getPointLineDistanceCut((Point2D)new Point2D(x * zoomX, y * zoomY), (Line)line);
                if (d < 5.0) {
                    return e;
                }
                ++i;
            }
        }
        for (Group subGroup : group.getGroups()) {
            Edge test = DiagramUtil.getSelectedEdge(subGroup, x, y, zoomX, zoomY);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    public static int getSelectedEdgeSegment(Edge edge, double x, double y, double zoomX, double zoomY) {
        List<Point> points = DiagramUtil.getEdgePoints(edge);
        int i = 1;
        while (i < points.size()) {
            Line line = new Line(points.get(i - 1).getX() * zoomX, points.get(i - 1).getY() * zoomY, points.get(i).getX() * zoomX, points.get(i).getY() * zoomY);
            double d = MathUtil.getPointLineDistanceCut((Point2D)new Point2D(x * zoomX, y * zoomY), (Line)line);
            if (d < 5.0) {
                return i - 1;
            }
            ++i;
        }
        return -1;
    }

    public static Node getSelectedNode(Diagram diagram, double x, double y) {
        return DiagramUtil.getSelectedNode(diagram, x, y, 1.0, 1.0);
    }

    public static Node getSelectedNode(Diagram diagram, double x, double y, double zoomX, double zoomY) {
        return DiagramUtil.getSelectedNode(diagram, x, y, 1.0, 1.0, 0.0);
    }

    public static Node getSelectedNode(Diagram diagram, double x, double y, double zoomX, double zoomY, double margin) {
        Node selectedNode = null;
        if (diagram == null) {
            return null;
        }
        for (Group group : diagram.getGroups()) {
            Node test = DiagramUtil.getSelectedNode(group, x, y, zoomX, zoomY, margin);
            if (test == null) continue;
            return test;
        }
        return selectedNode;
    }

    public static Node getSelectedNode(Group group, double x, double y, double zoomX, double zoomY, double margin) {
        for (Group subGroup : group.getGroups()) {
            Node test = DiagramUtil.getSelectedNode(subGroup, x, y, zoomX, zoomY, margin);
            if (test == null) continue;
            return test;
        }
        ListIterator iterator = group.getNodes().listIterator(group.getNodes().size());
        while (iterator.hasPrevious()) {
            Node node = (Node)iterator.previous();
            if (node.getElement() == null) continue;
            double offsetX = node.getDeltaScreenX() / zoomX;
            double offsetY = node.getDeltaScreenY() / zoomY;
            if (!(x > node.getX() - margin + offsetX) || !(x < node.getX() + margin + offsetX + node.getWidth() / zoomX) || !(y > node.getY() - margin + offsetY) || !(y < node.getY() + margin + offsetY + node.getHeight() / zoomY) || node.getElement() == null && node.getData() == null) continue;
            return node;
        }
        return null;
    }

    public static List<DElement> getSelectedNodes(Diagram diagram, Frame frame) {
        return DiagramUtil.getSelectedNodes(diagram, frame, 1.0, 1.0);
    }

    public static List<DElement> getSelectedNodes(Diagram diagram, Frame frame, double zoomX, double zoomY) {
        ArrayList<DElement> selectedNodes = new ArrayList<DElement>();
        for (Group g : diagram.getGroups()) {
            selectedNodes.addAll(DiagramUtil.getSelectedNodes(g, frame, zoomX, zoomY));
        }
        return selectedNodes;
    }

    public static List<DElement> getSelectedNodes(Group g, Frame frame, double zoomX, double zoomY) {
        double offsetY;
        double offsetX;
        ArrayList<DElement> selectedNodes = new ArrayList<DElement>();
        for (Text text : g.getTexts()) {
            offsetX = text.getDeltaScreenX() / zoomX;
            offsetY = text.getDeltaScreenY() / zoomY;
            if (!(text.getX() > frame.getX() + offsetX) || !(text.getX() + text.getWidth() / zoomX + text.getDeltaScreenX() < frame.getX() + offsetX + frame.getWidth()) || !(text.getY() > frame.getY() + offsetY) || !(text.getY() + text.getHeight() / zoomY < frame.getY() + offsetY + frame.getHeight())) continue;
            selectedNodes.add((DElement)text);
        }
        for (Node node : g.getNodes()) {
            offsetX = node.getDeltaScreenX() / zoomX;
            offsetY = node.getDeltaScreenY() / zoomY;
            if (!(node.getX() > frame.getX() + offsetX) || !(node.getX() + node.getWidth() / zoomX + node.getDeltaScreenX() < frame.getX() + offsetX + frame.getWidth()) || !(node.getY() > frame.getY() + offsetY) || !(node.getY() + node.getHeight() / zoomY < frame.getY() + offsetY + frame.getHeight())) continue;
            selectedNodes.add((DElement)node);
        }
        for (Edge edge : g.getEdges()) {
            List<Point> points = DiagramUtil.getEdgePoints(edge);
            if (points.size() < 2) continue;
            boolean inside = false;
            if (points.get(0).getX() > frame.getX() && points.get(0).getX() < frame.getX() + frame.getWidth() && points.get(0).getY() > frame.getY() && points.get(0).getY() < frame.getY() + frame.getHeight()) {
                inside = true;
            }
            if (!inside) continue;
            boolean intersects = false;
            int index = 1;
            while (index < points.size()) {
                Line line = new Line(points.get(index - 1).getX(), points.get(index - 1).getY(), points.get(index).getX(), points.get(index).getY());
                Point2D intersectionPoint = MathUtil.getIntersection((Line)line, (Frame)frame);
                if (intersectionPoint != null) {
                    intersects = true;
                    break;
                }
                ++index;
            }
            if (intersects) continue;
            selectedNodes.add((DElement)edge);
        }
        for (Group subGroup : g.getGroups()) {
            selectedNodes.addAll(DiagramUtil.getSelectedNodes(subGroup, frame, zoomX, zoomY));
        }
        return selectedNodes;
    }

    public static List<Point> getEdgePoints(Edge e) {
        return DiagramUtil.getEdgePoints(e, 0.0, 0.0);
    }

    public static List<Point> getEdgePoints(Edge e, double deltaX, double deltaY) {
        ArrayList<Point> points = new ArrayList<Point>();
        List pointsInner = e.getPoints();
        if (e.getSource() != null) {
            points.add(new Point(deltaX + e.getSource().getX() + e.getSource().getWidth() / 2.0, deltaY + e.getSource().getY() + e.getSource().getHeight() / 2.0));
        }
        if (pointsInner != null) {
            for (Point p : pointsInner) {
                points.add(new Point(p.getX() + deltaX, p.getY() + deltaY));
            }
        }
        if (e.getTarget() != null) {
            points.add(new Point(deltaX + e.getTarget().getX() + e.getTarget().getWidth() / 2.0, deltaY + e.getTarget().getY() + e.getTarget().getHeight() / 2.0));
        }
        return points;
    }

    public static Text getSelectedText(Diagram diagram, double x, double y, double zoomX, double zoomY) {
        Text selectedText = null;
        if (diagram == null) {
            return null;
        }
        for (Group group : diagram.getGroups()) {
            Text test = DiagramUtil.getSelectedText(group, x, y, zoomX, zoomY);
            if (test == null) continue;
            return test;
        }
        return selectedText;
    }

    public static Text getSelectedText(Group group, double x, double y, double zoomX, double zoomY) {
        for (Text text : group.getTexts()) {
            if (text.getElement() == null) continue;
            double offsetX = text.getDeltaScreenX() / zoomX;
            double offsetY = text.getDeltaScreenY() / zoomY;
            if (!(x > text.getX() + offsetX) || !(x < text.getX() + offsetX + text.getWidth() / zoomX) || !(y > text.getY() + offsetY) || !(y < text.getY() + offsetY + text.getHeight() / zoomY) || text.getElement() == null && text.getData() == null) continue;
            return text;
        }
        for (Group subGroup : group.getGroups()) {
            Text test = DiagramUtil.getSelectedText(subGroup, x, y, zoomX, zoomY);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    public static double snapToGrid(double v1, double v2, double dv) {
        double dist1 = v1 % dv;
        double dist2 = v2 % dv;
        double width = Math.abs(v2 - v1);
        boolean widthCloser = false;
        double dist = dist1;
        int min = (int)(v1 / dv);
        if (dist2 < dist1) {
            widthCloser = true;
            dist = dist2;
            min = (int)(v2 / dv);
        }
        if (dist > dv / 2.0) {
            if (widthCloser) {
                return (double)(min + 1) * dv - width;
            }
            return (double)(min + 1) * dv;
        }
        if (Math.abs(dist) > dv / 2.0) {
            if (widthCloser) {
                return (double)(min - 1) * dv - width;
            }
            return (double)(min - 1) * dv;
        }
        if (widthCloser) {
            return (double)min * dv - width;
        }
        return (double)min * dv;
    }

    public static Map<String, List<Double>> getCloserPosition(List<Node> nodes, Node node) {
        HashMap<String, List<Double>> map = new HashMap<String, List<Double>>();
        double width = node.getWidth();
        double height = node.getHeight();
        double xMin = node.getX();
        double xMax = node.getX() + node.getWidth();
        double xMoy = node.getX() + node.getWidth() / 2.0;
        double yMin = node.getY();
        double yMax = node.getY() + node.getHeight();
        double yMoy = node.getY() + node.getHeight() / 2.0;
        double valueX = Math.abs(xMax - xMin);
        double valueY = Math.abs(yMax - yMin);
        Double posXMin = null;
        Double posYMin = null;
        Double edgePos = null;
        for (Node subNode : nodes) {
            IElement element;
            if (subNode.getElement() == null || !(subNode.getElement() instanceof IElement) || (element = (IElement)subNode.getElement()).giGetElementType().getName().equalsIgnoreCase("connection")) continue;
            double subXMin = subNode.getX();
            double subXMax = subNode.getX() + subNode.getWidth();
            double subXMoy = subNode.getX() + subNode.getWidth() / 2.0;
            if (Math.abs(subXMin - xMin) < Math.abs(valueX)) {
                valueX = Math.abs(subXMin - xMin);
                posXMin = subXMin;
                edgePos = subXMin;
            }
            if (Math.abs(subXMax - xMax) < Math.abs(valueX)) {
                valueX = Math.abs(subXMax - xMax);
                posXMin = subXMax - width;
                edgePos = subXMax;
            }
            if (Math.abs(subXMoy - xMoy) < Math.abs(valueX)) {
                valueX = Math.abs(subXMoy - xMoy);
                posXMin = subXMoy - width / 2.0;
                edgePos = subXMoy;
            }
            if (Math.abs(valueX) < 50.0) {
                if (map.containsKey("x")) {
                    List values = (List)map.get("x");
                    if (Math.abs(valueX) < (Double)values.get(1)) {
                        ArrayList<Double> newValues = new ArrayList<Double>();
                        newValues.add(posXMin);
                        newValues.add(Math.abs(valueX));
                        newValues.add(edgePos);
                        map.put("x", newValues);
                    }
                } else {
                    ArrayList<Double> newValues = new ArrayList<Double>();
                    newValues.add(posXMin);
                    newValues.add(Math.abs(valueX));
                    newValues.add(edgePos);
                    map.put("x", newValues);
                }
            }
            double subYMin = subNode.getY();
            double subYMax = subNode.getY() + subNode.getHeight();
            double subYMoy = subNode.getY() + subNode.getHeight() / 2.0;
            if (Math.abs(subYMin - yMin) < Math.abs(valueY)) {
                valueY = Math.abs(subYMin - yMin);
                posYMin = subYMin;
                edgePos = subYMin;
            }
            if (Math.abs(subYMax - yMax) < Math.abs(valueY)) {
                valueY = Math.abs(subYMax - yMax);
                posYMin = subYMax - height;
                edgePos = subYMax;
            }
            if (Math.abs(subYMoy - yMoy) < Math.abs(valueY)) {
                valueY = Math.abs(subYMoy - yMoy);
                posYMin = subYMoy - height / 2.0;
                edgePos = subYMoy;
            }
            if (!(Math.abs(valueY) < 50.0)) continue;
            if (map.containsKey("y")) {
                List values = (List)map.get("y");
                if (!(Math.abs(valueY) < (Double)values.get(1))) continue;
                ArrayList<Double> newValues = new ArrayList<Double>();
                newValues.add(posYMin);
                newValues.add(Math.abs(valueY));
                newValues.add(edgePos);
                map.put("y", newValues);
                continue;
            }
            ArrayList<Double> newValues = new ArrayList<Double>();
            newValues.add(posYMin);
            newValues.add(Math.abs(valueY));
            newValues.add(edgePos);
            map.put("y", newValues);
        }
        return map;
    }

    public static List<Node> getAllNodes(Diagram diagram) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (diagram == null) {
            return nodes;
        }
        for (Group group : diagram.getGroups()) {
            nodes.addAll(DiagramUtil.getAllNodes(group));
        }
        return nodes;
    }

    public static List<Node> getAllNodes(Group group) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Group subGroup : group.getGroups()) {
            nodes.addAll(DiagramUtil.getAllNodes(subGroup));
        }
        for (Node node : group.getNodes()) {
            if (node.getElement() == null && node.getData() == null) continue;
            nodes.add(node);
        }
        return nodes;
    }
}

