/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.diagram.editor;

import java.util.List;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.Edge;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.ui.diagram.DiagramUtil;
import net.edgemind.ibee.ui.diagram.MouseButton;
import net.edgemind.ibee.ui.diagram.editor.DiagramEditor;
import net.edgemind.ibee.ui.diagram.editor.EditorMode;
import net.edgemind.ibee.util.math.Line;

public abstract class ResizeLineMode
extends EditorMode {
    private Edge origEdge;
    private Group overlay;
    private List<Point> current;
    private int segment;
    private boolean isHorizontal;

    protected abstract void commitSize(List<Point> var1);

    public ResizeLineMode(DiagramEditor editor, Edge origEdge, int segment) {
        super(editor);
        this.segment = segment;
        this.origEdge = origEdge;
        this.overlay = new Group();
        this.editor.addOverlay(this.overlay);
        this.current = DiagramUtil.getEdgePoints(origEdge);
        List<Point> points = DiagramUtil.getEdgePoints(origEdge);
        Line line = new Line(points.get(segment).getX(), points.get(segment).getY(), points.get(segment + 1).getX(), points.get(segment + 1).getY());
        this.isHorizontal = this.isHorizontal(line);
    }

    @Override
    public boolean mouseMove(double x, double y) {
        this.overlay.clear();
        int gridWidth = this.editor.getDiagramPanel().getGridWidth();
        double diagramX = this.editor.translateX(x);
        double diagramY = this.editor.translateY(y);
        diagramX = DiagramUtil.snapToGrid(diagramX, diagramX, gridWidth);
        diagramY = DiagramUtil.snapToGrid(diagramY, diagramY, gridWidth);
        if (this.isHorizontal) {
            this.current.get(this.segment).setY(diagramY);
            this.current.get(this.segment + 1).setY(diagramY);
        } else {
            this.current.get(this.segment).setX(diagramX);
            this.current.get(this.segment + 1).setX(diagramX);
        }
        this.refreshOverlay();
        return true;
    }

    private boolean isHorizontal(Line line) {
        return line.getY1() == line.getY2();
    }

    private boolean isVertical(Line line) {
        return line.getX1() == line.getX2();
    }

    private void refreshOverlay() {
        Edge edge = new Edge();
        edge.setPoints(this.current);
        edge.setForeColor(new Color(205, 0, 205));
        this.overlay.addEdge(edge);
        this.editor.repaintOverlay();
    }

    @Override
    public boolean mouseUp(double x, double y, MouseButton btn) {
        this.overlay.clear();
        this.editor.setEditorMode(null);
        this.commitSize(this.current);
        this.editor.refreshPage();
        return true;
    }

    @Override
    public boolean mouseDown(double x, double y, MouseButton btn) {
        return true;
    }

    @Override
    public void init() {
    }

    @Override
    public void dispose() {
    }
}

