/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.diagram.editor;

import net.edgemind.ibee.core.command.ExecutionException;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.ui.diagram.editor.DiagramEditor;
import net.edgemind.ibee.ui.toolbar.IToolbar;
import net.edgemind.ibee.ui.toolbar.ToolBar;
import net.edgemind.ibee.ui.toolbar.ToolbarItem;

public class StandardEditorToolbar {
    private IToolbar toolbar;
    private DiagramEditor editor;

    public void setEditor(DiagramEditor editor) {
        this.editor = editor;
    }

    public IToolbar create() {
        this.toolbar = new ToolBar();
        ToolbarItem item = new ToolbarItem("Undo", "img/ui/undo.svg"){

            @Override
            public void click() {
                IbeeResource cfr_ignored_0 = (IbeeResource)StandardEditorToolbar.this.editor.getResource();
                try {
                    StandardEditorToolbar.this.editor.getCommandStack().undo();
                }
                catch (ExecutionException e) {
                    LogUtil.log((Throwable)e);
                }
                StandardEditorToolbar.this.editor.rebuildDiagram();
            }
        };
        this.toolbar.addItem(item);
        item = new ToolbarItem("Redo", "img/ui/redo.svg"){

            @Override
            public void click() {
                IbeeResource cfr_ignored_0 = (IbeeResource)StandardEditorToolbar.this.editor.getResource();
                try {
                    StandardEditorToolbar.this.editor.getCommandStack().redo();
                }
                catch (ExecutionException e) {
                    LogUtil.log((Throwable)e);
                }
                StandardEditorToolbar.this.editor.rebuildDiagram();
            }
        };
        this.toolbar.addItem(item);
        item = new ToolbarItem("Zoom -", "img/ui/zoomminus2.svg"){

            @Override
            public void click() {
                StandardEditorToolbar.this.editor.decZoom(1);
            }
        };
        this.toolbar.addItem(item);
        item = new ToolbarItem("Zoom +", "img/ui/zoomplus2.svg"){

            @Override
            public void click() {
                StandardEditorToolbar.this.editor.incZoom(1);
            }
        };
        this.toolbar.addItem(item);
        item = new ToolbarItem("Center", "img/ui/icon_center_24x24.png"){

            @Override
            public void click() {
                StandardEditorToolbar.this.editor.center();
            }
        };
        this.toolbar.addItem(item);
        return this.toolbar;
    }

    public IToolbar getToolbar() {
        return this.toolbar;
    }
}

