/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.diagram.viewer;

import jsinterop.annotations.JsType;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.DElement;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Group;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.core.diagram.Rect;
import net.edgemind.ibee.core.diagram.Symbol;
import net.edgemind.ibee.ui.common.listener.IMouseDownListener;
import net.edgemind.ibee.ui.common.listener.IMouseMoveListener;
import net.edgemind.ibee.ui.common.listener.IMouseUpListener;
import net.edgemind.ibee.ui.diagram.DiagramPanel;
import net.edgemind.ibee.ui.diagram.DiagramUtil;
import net.edgemind.ibee.ui.diagram.MouseButton;
import net.edgemind.ibee.ui.diagram.viewer.DiagramViewer;
import net.edgemind.ibee.util.math.Frame;

@JsType(namespace="ui")
public class SelectionViewer
extends DiagramViewer {
    private boolean down = false;
    double lastX;
    double lastY;
    protected boolean canZoomHorizontal = true;
    protected boolean canZoomVertical = true;
    protected boolean canTranslateHorizontal = true;
    protected boolean canTranslateVertical = true;
    private Color selectionColor = Color.EMORANGE;
    private Group selectionOverlay;
    private Frame visibleFrame = new Frame();

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public void canZoomHorizontal(boolean value) {
        this.canZoomHorizontal = value;
    }

    public void canZoomVertical(boolean value) {
        this.canZoomVertical = value;
    }

    public void canTranslateHorizontal(boolean value) {
        this.canTranslateHorizontal = value;
    }

    public void canTranslateVertical(boolean value) {
        this.canTranslateVertical = value;
    }

    public SelectionViewer(DiagramPanel diagramPanel) {
        super(diagramPanel);
        this.getDiagramPanel().setToolbarEnabled(true);
        this.getDiagramPanel().setContextMenuEnabled(true);
        this.getDiagramPanel().setHorizontalScrollbarEnabled(false);
        this.getDiagramPanel().setVerticalScrollbarEnabled(false);
        this.diagramPanel.translateToCenterX(false);
        this.diagramPanel.translateToCenterY(false);
        this.selectionOverlay = new Group();
        this.diagramPanel.addOverlay(this.selectionOverlay);
    }

    @Override
    public void create() {
        this.diagramPanel.setVerticalScrollbarEnabled(false);
        this.diagramPanel.setHorizontalScrollbarEnabled(false);
        this.diagramPanel.addMouseDownListener(new IMouseDownListener(){

            @Override
            public void mouseDown(double x, double y, MouseButton btn) {
                if (!SelectionViewer.this.canZoomHorizontal && !SelectionViewer.this.canZoomVertical) {
                    return;
                }
                DiagramUtil.getSelectedDiagramElement(SelectionViewer.this.diagramPanel.getDiagram(), SelectionViewer.this.diagramPanel.translateX(x), SelectionViewer.this.diagramPanel.translateY(y), SelectionViewer.this.diagramPanel.getZoomX(), SelectionViewer.this.diagramPanel.getZoomY());
                SelectionViewer.this.selectionOverlay.clear();
                SelectionViewer.this.down = true;
                SelectionViewer.this.lastX = x;
                SelectionViewer.this.lastY = y;
            }
        });
        this.diagramPanel.addMouseUpListener(new IMouseUpListener(){

            @Override
            public void mouseUp(double x, double y, MouseButton btn) {
                SelectionViewer.this.down = false;
                SelectionViewer.this.selectionOverlay.clear();
                if (x == SelectionViewer.this.lastX || y == SelectionViewer.this.lastY) {
                    return;
                }
                if (x < SelectionViewer.this.lastX) {
                    SelectionViewer.this.setDiagram(SelectionViewer.this.getDiagram());
                    SelectionViewer.this.refresh();
                    return;
                }
                x = SelectionViewer.this.diagramPanel.translateX(x);
                y = SelectionViewer.this.diagramPanel.translateY(y);
                SelectionViewer.this.lastX = SelectionViewer.this.diagramPanel.translateX(SelectionViewer.this.lastX);
                SelectionViewer.this.lastY = SelectionViewer.this.diagramPanel.translateY(SelectionViewer.this.lastY);
                if (Math.abs(x - SelectionViewer.this.lastX) < 3.0 && Math.abs(y - SelectionViewer.this.lastY) < 3.0) {
                    SelectionViewer.this.refresh();
                    return;
                }
                if (SelectionViewer.this.canZoomHorizontal) {
                    SelectionViewer.this.visibleFrame.setWidth(Math.abs(x - SelectionViewer.this.lastX));
                }
                if (SelectionViewer.this.canZoomVertical) {
                    SelectionViewer.this.visibleFrame.setHeight(Math.abs(y - SelectionViewer.this.lastY));
                }
                if (SelectionViewer.this.canTranslateHorizontal) {
                    SelectionViewer.this.visibleFrame.setX(Math.min(x, SelectionViewer.this.lastX));
                }
                if (SelectionViewer.this.canTranslateVertical) {
                    SelectionViewer.this.visibleFrame.setY(Math.min(y, SelectionViewer.this.lastY));
                }
                SelectionViewer.this.refresh();
            }
        });
        this.diagramPanel.addMouseMoveListener(new IMouseMoveListener(){

            @Override
            public void mouseMove(double x, double y) {
                if (!SelectionViewer.this.down) {
                    return;
                }
                SelectionViewer.this.selectionOverlay.clear();
                Node rectangle = new Node();
                rectangle.setX(SelectionViewer.this.lastX);
                rectangle.setY(SelectionViewer.this.lastY);
                rectangle.setWidth(x - SelectionViewer.this.lastX);
                rectangle.setHeight(y - SelectionViewer.this.lastY);
                rectangle.setForeColor(SelectionViewer.this.selectionColor);
                rectangle.setBackColor(null);
                rectangle.setSymbol((Symbol)new Rect());
                rectangle.setPositioning(DElement.Positioning.Viewer);
                SelectionViewer.this.selectionOverlay.addNode(rectangle);
                SelectionViewer.this.paintOverlay();
            }
        });
        this.getDiagramPanel().create();
    }

    @Override
    public void setDiagram(Diagram diagram) {
        this.diagramPanel.setDiagram(diagram);
        if (diagram == null) {
            return;
        }
        Frame frame = new Frame();
        frame.copy(diagram.getSize(false));
        this.visibleFrame.setX(frame.getX() - this.marginX * (frame.getWidth() / 100.0));
        this.visibleFrame.setY(frame.getY() - this.marginY * (frame.getHeight() / 100.0));
        this.visibleFrame.setWidth(frame.getWidth() + 2.0 * this.marginX * (frame.getWidth() / 100.0));
        this.visibleFrame.setHeight(frame.getHeight() + 2.0 * this.marginY * (frame.getHeight() / 100.0));
    }

    @Override
    public void refresh() {
        this.diagramPanel.setTranslateX(this.visibleFrame.getX());
        this.diagramPanel.setTranslateY(this.visibleFrame.getY());
        double width = this.diagramPanel.getClientWidth();
        double height = this.diagramPanel.getClientHeight();
        this.getDiagramPanel().setZoomX(width / this.visibleFrame.getWidth());
        this.getDiagramPanel().setZoomY(height / this.visibleFrame.getHeight());
        this.diagramPanel.paintDiagram();
    }

    @Override
    public DiagramPanel getDiagramPanel() {
        return this.diagramPanel;
    }

    @Override
    public Diagram getDiagram() {
        return this.diagramPanel.getDiagram();
    }

    @Override
    public void paintOverlay() {
        this.diagramPanel.paintOverlay();
    }

    @Override
    public void setTranslateX(double translateX) {
        this.visibleFrame.setX(translateX);
    }

    @Override
    public void setTranslateY(double translateY) {
        this.visibleFrame.setY(translateY);
    }
}

