/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.menu;

import java.util.List;
import net.edgemind.ibee.ui.app.UiPart;
import net.edgemind.ibee.ui.menu.IMenu;
import net.edgemind.ibee.ui.menu.MenuContribution;
import net.edgemind.ibee.ui.menu.MenuExtension;
import net.edgemind.ibee.ui.menu.MenuFactory;
import net.edgemind.ibee.ui.menu.MenuRegistry;

public class MenuCreator {
    private MenuRegistry registry;

    public void setRegistry(MenuRegistry registry) {
        this.registry = registry;
    }

    public IMenu createMenu(String menuId, UiPart part) {
        IMenu menu = MenuFactory.createMenu();
        this.createMenu(menuId, part, menu);
        return menu;
    }

    public void createMenu(String menuId, UiPart part, IMenu parent) {
        MenuContribution menuContribution;
        MenuRegistry registry = this.registry;
        if (registry == null) {
            registry = MenuRegistry.getInstance();
        }
        if ((menuContribution = registry.getMenuContribution(menuId)) != null) {
            menuContribution.contributeToMenu(parent, part);
        }
        this.createMenuInternal(menuId, part, parent);
    }

    private void createMenuInternal(String menuId, UiPart part, IMenu parent) {
        MenuRegistry registry = this.registry;
        if (registry == null) {
            registry = MenuRegistry.getInstance();
        }
        List<MenuExtension> extensions = registry.getExtensions(menuId);
        Double priorityPrev = null;
        for (MenuExtension extension : extensions) {
            if (!registry.isFiltered(menuId, extension, part)) continue;
            double priority = extension.getPriority();
            if (priorityPrev != null && priority > priorityPrev) {
                parent.addItem(MenuFactory.createSeparatorItem());
            }
            priorityPrev = priority;
            MenuContribution menuContribution = extension.getMenuContribution();
            IMenu subMenu = menuContribution.contributeToMenu(parent, part);
            if (subMenu == null) continue;
            String subMenuId = menuContribution.getId();
            if (extension.getElide()) {
                this.createMenuInternal(subMenuId, part, parent);
                continue;
            }
            this.createMenuInternal(subMenuId, part, subMenu);
        }
    }
}

