/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.ui.common.UiData;
import net.edgemind.ibee.ui.common.event.SelectionEvent;
import net.edgemind.ibee.ui.common.listener.SelectionListener;
import net.edgemind.ibee.ui.menu.IMenu;
import net.edgemind.ibee.ui.menu.IMenuItem;

public class MenuItem
implements IMenuItem {
    private UiData data;
    private String title = "";
    private boolean isEnabled = true;
    private boolean isChecked = false;
    private boolean isCheckable = false;
    private boolean isSelected = false;
    private Map<String, Object> dataMap;
    double order = 0.0;
    private List<SelectionListener<IMenuItem>> clickHandler = new ArrayList<SelectionListener<IMenuItem>>();
    private String icon;
    protected Class iconClass;

    public MenuItem(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean getEnabled() {
        return this.isEnabled;
    }

    @Override
    public IMenuItem setEnabled(boolean value) {
        this.isEnabled = value;
        return this;
    }

    @Override
    public IMenuItem setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public IMenuItem setChecked(boolean value) {
        this.isChecked = value;
        return this;
    }

    @Override
    public boolean getChecked() {
        return this.isChecked;
    }

    @Override
    public boolean getCheckable() {
        return this.isCheckable;
    }

    @Override
    public IMenuItem setCheckable(boolean value) {
        this.isCheckable = value;
        return this;
    }

    @Override
    public IMenuItem setData(UiData data) {
        this.data = data;
        return this;
    }

    @Override
    public UiData getData() {
        return this.data;
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public IMenuItem setSelected(boolean value) {
        this.isSelected = value;
        return this;
    }

    public void setIcon(String path, Class clazz) {
        this.icon = path;
        this.iconClass = clazz;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public Class getIconClass() {
        return this.iconClass;
    }

    @Override
    public IMenuItem addClickHandler(SelectionListener<IMenuItem> l) {
        this.clickHandler.add(l);
        return this;
    }

    public void fireClick() {
        for (SelectionListener<IMenuItem> l : this.clickHandler) {
            l.onSelect(new SelectionEvent<MenuItem>(this));
        }
    }

    public void fireClick(double x, double y) {
        for (SelectionListener<IMenuItem> l : this.clickHandler) {
            l.onSelect(new SelectionEvent<MenuItem>(this, x, y));
        }
    }

    @Override
    public IMenuItem setOrder(double order) {
        this.order = order;
        return this;
    }

    @Override
    public double getOrder() {
        return this.order;
    }

    @Override
    public IMenuItem appendTo(IMenu menu) {
        menu.addItem(this);
        return this;
    }

    @Override
    public IMenuItem setData(String key, Object data) {
        if (this.dataMap == null) {
            this.dataMap = new HashMap<String, Object>();
        }
        this.dataMap.put(key, data);
        return this;
    }

    @Override
    public Object getData(String key) {
        if (this.dataMap == null) {
            return null;
        }
        return this.dataMap.get(key);
    }
}

