/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.app.IPart;
import net.edgemind.ibee.ui.app.UiPart;
import net.edgemind.ibee.ui.menu.IMenu;
import net.edgemind.ibee.ui.menu.MenuContext;
import net.edgemind.ibee.ui.menu.MenuContribution;
import net.edgemind.ibee.ui.menu.MenuExtension;
import net.edgemind.ibee.util.misc.IFilter;

public class MenuRegistry {
    static MenuRegistry instance = null;
    private Map<String, List<MenuExtension>> extensions = new HashMap<String, List<MenuExtension>>();
    private Map<String, MenuContribution> menus = new HashMap<String, MenuContribution>();
    private List<IFilter<MenuContext>> menuFilter = new ArrayList<IFilter<MenuContext>>();

    public static MenuRegistry getInstance() {
        if (instance == null) {
            instance = new MenuRegistry();
        }
        return instance;
    }

    public MenuExtension extendMenu(String menuId, MenuContribution contribution) {
        return this.extendMenu(menuId, contribution, 0.0);
    }

    public MenuExtension extendMenu(String menuId, String contributionId) {
        return this.extendMenu(menuId, contributionId, 0.0);
    }

    public MenuExtension extendMenu(String menuId, final String contributionId, double priority) {
        MenuExtension link = new MenuExtension();
        link.setMenuContribution(new MenuContribution(){

            @Override
            public IMenu contributeToMenu(IMenu parent, UiPart part) {
                MenuContribution contribution = MenuRegistry.this.getMenuContribution(contributionId);
                if (contribution == null) {
                    return null;
                }
                return contribution.contributeToMenu(parent, part);
            }

            @Override
            public String getId() {
                return contributionId;
            }
        });
        link.setPriority(priority);
        this.extendMenuInternal(menuId, link);
        return link;
    }

    public MenuExtension extendMenu(String menuId, MenuContribution contribution, double priority) {
        MenuExtension link = new MenuExtension();
        link.setMenuContribution(contribution);
        link.setPriority(priority);
        this.extendMenuInternal(menuId, link);
        return link;
    }

    private void extendMenuInternal(String menuId, MenuExtension link) {
        List<MenuExtension> extensions = this.extensions.get(menuId);
        if (extensions == null) {
            extensions = new ArrayList<MenuExtension>();
            this.extensions.put(menuId, extensions);
        }
        extensions.add(link);
        Collections.sort(extensions, new Comparator<MenuExtension>(){

            @Override
            public int compare(MenuExtension o1, MenuExtension o2) {
                if (o1.getPriority() < o2.getPriority()) {
                    return -1;
                }
                if (o1.getPriority() == o2.getPriority()) {
                    return 0;
                }
                return 1;
            }
        });
    }

    public List<MenuExtension> getExtensions(String id) {
        List<MenuExtension> extensions = this.extensions.get(id);
        if (extensions == null) {
            return Collections.EMPTY_LIST;
        }
        return extensions;
    }

    public void registerMenu(MenuContribution menu) {
        this.menus.put(menu.getId(), menu);
    }

    public MenuContribution getMenuContribution(String id) {
        return this.menus.get(id);
    }

    public void registerFilter(IFilter<MenuContext> filter) {
        this.menuFilter.add(filter);
    }

    public boolean isFiltered(String menu, MenuExtension extension, IPart part) {
        MenuContext context = new MenuContext();
        context.menu = menu;
        context.menuExtension = extension;
        context.part = part;
        for (IFilter<MenuContext> filter : this.menuFilter) {
            if (filter.accept((Object)context)) continue;
            return false;
        }
        return true;
    }
}

