/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.edgemind.ibee.ui.property.IEnumProperty;
import net.edgemind.ibee.ui.property.IPropertyModificationListener;
import net.edgemind.ibee.ui.property.Property;

public class EnumProperty<T>
extends Property<T>
implements IEnumProperty<T> {
    private List<T> enums = new ArrayList<T>();
    private List<String> enumLabels = new ArrayList<String>();
    private boolean nullAllowed = false;
    private String nullName = "None";

    public EnumProperty(String name, String label, Collection<T> enums, Collection<String> enumLabels) {
        super(name, label);
        Iterator<T> enumValueIterator = enums.iterator();
        Iterator<String> enumLabelIterator = enumLabels.iterator();
        while (enums.iterator().hasNext() && enumLabelIterator.hasNext()) {
            T enumValue = enumValueIterator.next();
            String enumLabel = enumLabelIterator.next();
            this.enums.add(enumValue);
            this.enumLabels.add(enumLabel);
        }
    }

    public EnumProperty(String name, String label, T[] enums, String[] enumLabels) {
        super(name, label);
        int index = 0;
        while (index < enums.length) {
            this.enums.add(enums[index]);
            this.enumLabels.add(enumLabels[index]);
            ++index;
        }
    }

    public EnumProperty(String name, String label, T[] enums) {
        super(name, label);
        int index = 0;
        while (index < enums.length) {
            this.enums.add(enums[index]);
            this.enumLabels.add(enums[index].toString());
            ++index;
        }
    }

    @Override
    public List<T> getEnums() {
        return this.enums;
    }

    @Override
    public List<String> getEnumLabels() {
        return this.enumLabels;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.nullAllowed && this.getValue() == null) {
            return true;
        }
        if (this.getValue() == null) {
            return false;
        }
        boolean valid = false;
        for (T nextEnum : this.enums) {
            if (this.getValue() != nextEnum) continue;
            valid = true;
            break;
        }
        return valid;
    }

    @Override
    public void setValue(Object object) {
        super.setValue(object);
    }

    @Override
    public void setNullAllowed(boolean v) {
        this.nullAllowed = v;
    }

    @Override
    public boolean getNullAllowed() {
        return this.nullAllowed;
    }

    @Override
    public void setNullName(String name) {
        this.nullName = name;
    }

    @Override
    public String getNullName() {
        return this.nullName;
    }

    @Override
    public void update(T[] enums, String[] enumLabels) {
        this.enums = new ArrayList<T>();
        this.enumLabels = new ArrayList<String>();
        int index = 0;
        while (index < enums.length) {
            this.enums.add(enums[index]);
            this.enumLabels.add(enumLabels[index]);
            ++index;
        }
        if (this.listeners != null) {
            for (IPropertyModificationListener listener : this.listeners) {
                listener.propertyModified(this);
            }
        }
    }
}

