/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.property;

import net.edgemind.ibee.ui.property.IProperty;
import net.edgemind.ibee.ui.property.IPropertyValidator;
import net.edgemind.ibee.util.string.StringUtil;

public class FloatingRangeValidator
implements IPropertyValidator<String> {
    private Double min = null;
    private Double max = null;
    private boolean acceptEmpty = true;

    public FloatingRangeValidator(Double min, Double max, boolean acceptEmpty) {
        this.min = min;
        this.max = max;
        this.acceptEmpty = acceptEmpty;
    }

    public FloatingRangeValidator(Double min, Double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean verify(IProperty<String> property) {
        Double value = StringUtil.toDouble((String)property.getValue(), null);
        if (value == null) {
            return this.acceptEmpty;
        }
        if (this.min != null && value < this.min) {
            return false;
        }
        return this.max == null || !(value > this.max);
    }

    public boolean validate(String value) {
        return false;
    }
}

