/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.ui.property.IProperty;
import net.edgemind.ibee.ui.property.IPropertyModificationListener;
import net.edgemind.ibee.ui.property.IPropertyValidator;

public class Property<T>
implements IProperty<T> {
    private String name;
    private String label = "";
    private T object;
    private boolean modifyable = true;
    private boolean isCritical = true;
    private List<IPropertyValidator<T>> validators;
    protected List<IPropertyModificationListener<T>> listeners;
    Map<String, Object> data = new HashMap<String, Object>();

    public Property(String name, String label) {
        this.name = name;
        this.label = label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isValid() {
        if (this.validators != null) {
            for (IPropertyValidator<T> validator : this.validators) {
                if (validator.verify(this)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void addValidation(IPropertyValidator<T> validator) {
        if (this.validators == null) {
            this.validators = new ArrayList<IPropertyValidator<T>>();
        }
        this.validators.add(validator);
    }

    @Override
    public void setValue(T object) {
        if (this.object == object) {
            return;
        }
        this.object = object;
        if (this.listeners != null) {
            for (IPropertyModificationListener<T> listener : this.listeners) {
                listener.propertyModified(this);
            }
        }
    }

    @Override
    public T getValue() {
        return this.object;
    }

    @Override
    public boolean getModifyable() {
        return this.modifyable;
    }

    @Override
    public void setModifyable(boolean value) {
        this.modifyable = value;
        if (this.listeners != null) {
            for (IPropertyModificationListener<T> listener : this.listeners) {
                listener.propertyModified(this);
            }
        }
    }

    @Override
    public void addModificationListener(IPropertyModificationListener<T> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPropertyModificationListener<T>>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void setData(String key, Object value) {
        this.data.put(key, value);
    }

    @Override
    public Object getData(String key) {
        return this.data.get(key);
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public void setCritical(boolean isCritical) {
        this.isCritical = isCritical;
    }
}

