/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.ui.z;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.ui.common.event.MouseOverEvent;
import net.edgemind.ibee.ui.common.event.SelectionEvent;
import net.edgemind.ibee.ui.common.listener.MouseOverListener;
import net.edgemind.ibee.ui.common.listener.SelectionListener;
import net.edgemind.ibee.ui.z.ZImage;
import net.edgemind.ibee.ui.z.renderer.AZComponent;

public class ZLink
extends AZComponent {
    private String text;
    private ZImage image;
    private String tooltip;
    private List<SelectionListener<ZLink>> clickHandler = new ArrayList<SelectionListener<ZLink>>();
    private List<MouseOverListener<ZLink>> mouseOverHandler = new ArrayList<MouseOverListener<ZLink>>();

    public ZLink() {
        this.text = "";
    }

    public ZLink(String text) {
        this.text = text;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setImage(ZImage image) {
        this.image = image;
    }

    public ZImage getImage() {
        return this.image;
    }

    public void addClickHandler(SelectionListener<ZLink> l) {
        this.clickHandler.add(l);
    }

    public void addMouseMoveHandler(MouseOverListener<ZLink> l) {
        this.mouseOverHandler.add(l);
    }

    public List<SelectionListener<ZLink>> getClickHandler() {
        return this.clickHandler;
    }

    public void fireClick(double x, double y) {
        for (SelectionListener<ZLink> l : this.clickHandler) {
            l.onSelect(new SelectionEvent<ZLink>(this, x, y));
        }
    }

    public void fireMouseOver(double x, double y) {
        for (MouseOverListener<ZLink> l : this.mouseOverHandler) {
            l.onMouseOver(new MouseOverEvent<ZLink>(this, x, y));
        }
    }

    @Override
    protected String[] getDefaultStyles() {
        return new String[]{"zlink"};
    }
}

