/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.edgemind.ibee.util.exec.IRunnableWithException1E;
import net.edgemind.ibee.util.misc.IFilter;
import net.edgemind.ibee.util.system.SystemUtil;

public class FileUtil {
    private static final int BUFFER_SIZE = 4096;

    public static boolean acceptFile(String filename, String extension) {
        if (extension == null) {
            return true;
        }
        return filename.endsWith(extension);
    }

    public static String addExtension(String path, String extension) {
        if (extension == null) {
            return path;
        }
        if (!((String)path).toLowerCase().endsWith("." + extension.toLowerCase())) {
            path = (String)path + "." + extension;
        }
        return path;
    }

    public static boolean copyFileOrDir(File fileOrDir, File targetDir) throws IOException {
        return FileUtil.copyFileOrDir(fileOrDir.getAbsolutePath(), targetDir.getAbsolutePath());
    }

    public static boolean copyFileOrDir(String fileOrDir, String targetDir) throws IOException {
        boolean isAsterisk;
        File file;
        if (!FileUtil.fileExists(targetDir)) {
            FileUtil.createDir(targetDir);
        }
        if ((file = (isAsterisk = FileUtil.extractFileName(fileOrDir).equals("*")) ? new File(FileUtil.extractFileDir(fileOrDir)) : new File(fileOrDir)).exists()) {
            if (file.isDirectory()) {
                File[] files;
                Object subDir = targetDir + File.separator + file.getName();
                if (isAsterisk) {
                    subDir = targetDir;
                }
                if ((files = file.listFiles()) != null) {
                    int index = 0;
                    while (index < files.length) {
                        FileUtil.copyFileOrDir(files[index].getAbsolutePath(), (String)subDir);
                        ++index;
                    }
                }
            }
            if (file.isFile()) {
                FileUtil.copyFile(file, new File(targetDir + File.separator + file.getName()));
            }
        }
        return true;
    }

    public static void copyFile(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buf = new byte[1024];
        while ((bytesRead = input.read(buf)) > 0) {
            output.write(buf, 0, bytesRead);
        }
    }

    public static void copyFile(InputStream input, File dest) throws IOException {
        FileOutputStream output = null;
        try {
            int bytesRead;
            output = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((bytesRead = input.read(buf)) > 0) {
                ((OutputStream)output).write(buf, 0, bytesRead);
            }
        }
        finally {
            input.close();
            ((OutputStream)output).close();
        }
    }

    public static void copyFile(File source, File dest) throws IOException {
        InputStream input = null;
        OutputStream output = null;
        try {
            if (!source.exists()) {
                throw new IOException("File does not exist: " + source.getAbsolutePath());
            }
            input = new FileInputStream(source);
            output = new FileOutputStream(dest);
            FileUtil.copyFile(input, output);
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public static void createDir(File dir) throws IOException {
        FileUtil.createDir(dir.getAbsolutePath());
    }

    public static void createDir(String dirName) throws IOException {
        File f = new File(dirName);
        if (f.exists()) {
            if (f.isDirectory()) {
                return;
            }
            throw new IOException("cannot create directory " + dirName + ": file with same name exists");
        }
        if (!new File(dirName).mkdirs()) {
            throw new IOException("cannot create directory " + dirName + ": no permission?");
        }
    }

    public static void createFile(String fileName, String content) throws IOException {
        File f = new File(fileName);
        if (f.exists()) {
            throw new IOException("File '" + fileName + "' exists already.");
        }
        try {
            FileWriter writer = new FileWriter(f);
            writer.write(content);
            writer.close();
        }
        catch (IOException io) {
            throw new IOException(io);
        }
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public static boolean deleteFile(String path) {
        File f = new File(path);
        return FileUtil.deleteFile(f);
    }

    public static boolean deleteFile(File f) {
        if (f.exists()) {
            File[] files;
            if (f.isDirectory() && (files = f.listFiles()) != null) {
                int index = 0;
                while (index < files.length) {
                    File file = files[index];
                    FileUtil.deleteFile(file);
                    ++index;
                }
            }
            return f.delete();
        }
        return false;
    }

    public static boolean dirExists(String fileName) {
        File f = new File(fileName);
        return f.exists() && f.isDirectory();
    }

    public static boolean dirIsEmpty(String dir) {
        File testFile = new File(dir);
        if (!testFile.exists()) {
            return true;
        }
        return testFile.listFiles() != null && testFile.listFiles().length == 0;
    }

    public static String extractFileDir(String filePath) {
        if (filePath == null) {
            return null;
        }
        return FileUtil.extractFileDir(new File(filePath));
    }

    public static String extractFileDir(File file) {
        if (file == null) {
            return null;
        }
        String parent = file.getParent();
        if (parent == null) {
            parent = "";
        }
        return parent;
    }

    public static String extractFileName(String filePath) {
        if (filePath == null) {
            return null;
        }
        return new File(filePath).getName();
    }

    public static boolean fileExists(File file) {
        return file.exists();
    }

    public static boolean fileExists(String fileName) {
        if (fileName == null) {
            return false;
        }
        if (fileName.startsWith("file://")) {
            fileName = fileName.substring("file://".length());
        }
        File file = new File(fileName);
        return file.exists();
    }

    public static String getDir(String path) {
        int index = -1;
        index = path.length() - 1;
        while (index >= 0) {
            if (path.charAt(index) == '/' || path.charAt(index) == '\\') break;
            --index;
        }
        if (index >= 0) {
            path = path.substring(0, index + 1);
        }
        return path;
    }

    public static String getExtension(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(".");
        if (index >= 0) {
            String extension = path.substring(index + 1);
            if (extension.contains(File.separator)) {
                return null;
            }
            return extension;
        }
        return null;
    }

    public static String getExtension(File file) {
        return FileUtil.getExtension(file.getAbsolutePath());
    }

    public static String getFileName(String path) {
        return FileUtil.extractFileName(path);
    }

    public static long getFolderSize(String dirName) {
        return FileUtil.getFolderSize(new File(dirName));
    }

    public static long getFolderSize(File directory) {
        long length = 0L;
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            length = file.isFile() ? (length += file.length()) : (length += FileUtil.getFolderSize(file));
            ++n2;
        }
        return length;
    }

    public static String getRelativePath(String path, String base) {
        return FileUtil.getRelativePath(new File(path), new File(base));
    }

    public static String getRelativePath(File path, File base) {
        URI relative = FileUtil.getRelativeURI(path, base);
        if (relative != null) {
            return relative.getPath();
        }
        return null;
    }

    public static URI getRelativeURI(File child, File parent) {
        URI childURI;
        URI parentURI = parent.toURI();
        URI rel = parentURI.relativize(childURI = child.toURI());
        if (rel == null || rel == childURI) {
            return null;
        }
        return rel;
    }

    public static String getParentDir(String dir) {
        while (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        String result = FileUtil.getDir(dir);
        return result;
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getWorkingDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static boolean hasExtension(File file, String ext) {
        return FileUtil.hasExtension(file.getAbsolutePath(), ext);
    }

    public static boolean hasExtension(String path, String ext) {
        return path.toLowerCase().endsWith("." + ext.toLowerCase());
    }

    public static boolean hasParent(File file, File parent) {
        try {
            return file.getCanonicalPath().startsWith(parent.getCanonicalPath() + File.separator);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean isXmlFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InputStream ensureUnzippedStream(InputStream in, String zipEntry) throws IOException {
        return FileUtil.openZippedInputStream(in, zipEntry);
    }

    public static BufferedInputStream ensureBufferedInputStream(InputStream stream) throws IOException {
        if (!(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        return (BufferedInputStream)stream;
    }

    public static InputStream ensureResetableStream(File file) throws IOException {
        return FileUtil.ensureResetableStream(new FileInputStream(file));
    }

    public static InputStream ensureResetableStream(InputStream stream) throws IOException {
        if (!(stream instanceof ByteArrayInputStream)) {
            stream = new ByteArrayInputStream(stream.readAllBytes());
        }
        return stream;
    }

    public static InputStream ensureResetableZippedStream(File file, String zipEntry) throws IOException {
        return FileUtil.ensureResetableZippedStream(new FileInputStream(file), zipEntry);
    }

    public static InputStream ensureResetableZippedStream(InputStream stream, String zipEntry) throws IOException {
        return FileUtil.ensureResetableStream(FileUtil.ensureUnzippedStream(stream, zipEntry));
    }

    public static boolean isZipStream(BufferedInputStream stream) {
        DataInputStream in = null;
        try {
            stream.mark(4);
            in = new DataInputStream(stream);
            int test = in.readInt();
            stream.reset();
            return test == 1347093252;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isZipFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            return false;
        }
        if (file.length() < 4L) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
                int test = in.readInt();
                boolean bl = test == 1347093252;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String lineSeparator() {
        return System.lineSeparator();
    }

    public static String normalizeDir(String dir) {
        if (!((String)dir).endsWith(File.separator)) {
            dir = (String)dir + File.separator;
        }
        return dir;
    }

    public static void openFile(File file) throws IOException {
        try {
            String[] cmdarray = SystemUtil.isWindows() ? new String[]{"cmd.exe", "/c", "start", "\"\"", "\"" + file.getAbsolutePath() + "\""} : new String[]{"xdg-open", file.getAbsolutePath()};
            Runtime.getRuntime().exec(cmdarray);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    public static List<File> readDirs(File dir, Boolean recursive, String pattern) throws IOException {
        return FileUtil.readDirs(dir.getAbsolutePath(), recursive, pattern, dir.getAbsolutePath() + "/").stream().map(filePath -> new File((String)filePath)).collect(Collectors.toList());
    }

    public static List<String> readDirs(String dirpath, Boolean recursive, String pattern, String leadingChars) throws IOException {
        File f = new File(dirpath);
        ArrayList<String> dirs = new ArrayList<String>();
        if (!f.isDirectory()) {
            return dirs;
        }
        File[] filehandles = f.listFiles();
        if (filehandles == null) {
            throw new IOException(String.format("Cannot read files from directory %s, maybe permission problem.", dirpath));
        }
        int i = 0;
        while (i < filehandles.length) {
            if (filehandles[i].isDirectory()) {
                String fileName = filehandles[i].getName();
                if (pattern == null) {
                    dirs.add(leadingChars + fileName);
                } else {
                    Pattern p = Pattern.compile(pattern, 2);
                    Matcher matcher = p.matcher(fileName);
                    if (matcher.find()) {
                        dirs.add(leadingChars + fileName);
                    }
                }
                if (recursive.booleanValue()) {
                    List<String> filesSubdir = FileUtil.readDirs(filehandles[i].getAbsolutePath(), recursive, pattern, leadingChars + filehandles[i].getName() + File.separator);
                    dirs.addAll(filesSubdir);
                }
            }
            ++i;
        }
        return dirs;
    }

    public static List<File> readFilesFromDir(File dir, boolean recursive, String pattern) throws IOException {
        return FileUtil.readFiles(dir.getAbsolutePath(), recursive, pattern, dir.getAbsolutePath() + "/").stream().map(filePath -> new File((String)filePath)).collect(Collectors.toList());
    }

    public static List<File> findFiles(File dir, boolean recursive, IFilter<File> fileFilter) throws IOException {
        return FileUtil.findFiles(dir.getAbsolutePath(), recursive, fileFilter, dir.getAbsolutePath() + "/").stream().map(filePath -> new File((String)filePath)).collect(Collectors.toList());
    }

    public static List<String> readFiles(String dirpath, Boolean recursive, String pattern, String leadingChars) throws IOException {
        IFilter<File> fileFilter = pattern == null ? null : file -> {
            Pattern p = Pattern.compile(pattern, 2);
            Matcher matcher = p.matcher(file.getName());
            return matcher.find();
        };
        return FileUtil.findFiles(dirpath, recursive, fileFilter, leadingChars);
    }

    public static List<String> findFiles(String dirpath, Boolean recursive, IFilter<File> fileFilter, String leadingChars) throws IOException {
        File f = new File(dirpath);
        ArrayList<String> files = new ArrayList<String>();
        if (!f.isDirectory()) {
            return files;
        }
        File[] filehandles = f.listFiles();
        if (filehandles == null) {
            throw new IOException(String.format("Cannot read files from directory %s, maybe permission problem.", dirpath));
        }
        int i = 0;
        while (i < filehandles.length) {
            if (filehandles[i].isDirectory() && recursive.booleanValue()) {
                List<String> filesSubdir = FileUtil.findFiles(filehandles[i].getAbsolutePath(), recursive, fileFilter, leadingChars + filehandles[i].getName() + File.separator);
                files.addAll(filesSubdir);
            }
            if (filehandles[i].isFile()) {
                File file = filehandles[i];
                if (fileFilter == null || fileFilter.accept(file)) {
                    String fileName = file.getName();
                    files.add(leadingChars + fileName);
                }
            }
            ++i;
        }
        return files;
    }

    public static String readFileContent(File file) {
        try {
            return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String removeEndingSlashes(String path) {
        while (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length());
        }
        return path;
    }

    public static boolean rename(File file, String newName) {
        File newFile = new File(file.getParentFile(), newName);
        if (newFile.exists()) {
            return false;
        }
        return file.renameTo(newFile);
    }

    public static File replaceExtension(File path, String newExtension) {
        return new File(FileUtil.replaceExtension(path.getAbsolutePath(), newExtension));
    }

    /*
     * Unable to fully structure code
     */
    public static String replaceExtension(String path, String newExtension) {
        block1: {
            extension = FileUtil.getExtension(path);
            if (newExtension != null) ** GOTO lbl6
            newPath = extension != null ? path.substring(0, path.length() - extension.length() - 1) : path;
            break block1;
lbl-1000:
            // 1 sources

            {
                newExtension = newExtension.substring(1, newExtension.length());
lbl6:
                // 2 sources

                ** while (newExtension.startsWith((String)"."))
            }
lbl7:
            // 1 sources

            newPath = extension == null ? path.concat(".").concat(newExtension) : path.substring(0, path.length() - extension.length()).concat(newExtension);
        }
        return newPath;
    }

    public static void readZippedInputStream(File zipFile, String zipEntry, Consumer<InputStream> reader) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = FileUtil.openZippedInputStream(new BufferedInputStream(new FileInputStream(zipFile)), zipEntry);){
            reader.accept(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <E extends Exception> void readZippedInputStream(File zipFile, String zipEntry, IRunnableWithException1E<InputStream, E> reader) throws IOException, E {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = FileUtil.openZippedInputStream(new BufferedInputStream(new FileInputStream(zipFile)), zipEntry);){
            reader.run(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void readInputStream(File zipFile, Consumer<InputStream> reader) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));){
            reader.accept(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <E extends Exception> void readInputStream(File zipFile, IRunnableWithException1E<InputStream, E> reader) throws IOException, E {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));){
            reader.run(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static InputStream openInputStream(File file) throws IOException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static InputStream openZippedInputStream(File zipFile, String path) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));
        return FileUtil.openZippedInputStream(in, path);
    }

    public static InputStream openZippedInputStream(InputStream stream, String zipEntry) throws IOException {
        ZipInputStream zippedStream = new ZipInputStream(stream);
        ZipEntry entry = null;
        ZipEntry next = zippedStream.getNextEntry();
        while (next != null) {
            if (next.getName().equals(zipEntry)) {
                entry = next;
                break;
            }
            next = zippedStream.getNextEntry();
        }
        if (entry == null) {
            throw new IOException("No '" + zipEntry + "' entry found in compressed zip stream");
        }
        stream = zippedStream;
        return stream;
    }

    public static void writeOutputStream(File zipFile, Consumer<OutputStream> consumer) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zipFile));){
            consumer.accept(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <E extends Exception> void writeOutputStream(File zipFile, IRunnableWithException1E<OutputStream, E> consumer) throws IOException, E {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zipFile));){
            consumer.run(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeZippedOutputStream(File zipFile, String path, Consumer<OutputStream> consumer) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream out = FileUtil.openZippedOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)), path);){
            consumer.accept(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <E extends Exception> void writeZippedOutputStream(File zipFile, String path, IRunnableWithException1E<OutputStream, E> consumer) throws IOException, E {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream out = FileUtil.openZippedOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)), path);){
            consumer.run(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static OutputStream openZippedOutputStream(File zipFile, String path) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zipFile));
        return FileUtil.openZippedOutputStream(out, path);
    }

    public static OutputStream openZippedOutputStream(OutputStream stream, String path) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(stream);
        ZipEntry zipEntry = new ZipEntry(path);
        zipOut.putNextEntry(zipEntry);
        return zipOut;
    }

    public static boolean unzip(File zipFile, File destDir) throws IOException {
        return FileUtil.unzip(zipFile, destDir, null);
    }

    public static boolean unzip(File zipFile, File destDir, IFilter<String> pathFilter) throws IOException {
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry entry = zipIn.getNextEntry();
        boolean success = false;
        while (entry != null) {
            String filePath = String.valueOf(destDir) + File.separator + entry.getName();
            if (pathFilter != null && !pathFilter.accept(filePath)) continue;
            if (!entry.isDirectory()) {
                FileUtil.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdirs();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
            success = true;
        }
        zipIn.close();
        return success;
    }

    public static void zipFile(File fileToZip, File zipFile) throws IOException {
        FileUtil.zipFile(fileToZip, zipFile, true);
    }

    public static void zipFile(File fileToZip, File zipFile, boolean createRootDir) throws IOException {
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        if (fileToZip.exists() && fileToZip.isDirectory() && !createRootDir) {
            File[] children;
            File[] fileArray = children = fileToZip.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                FileUtil.zipFile(childFile, childFile.getName(), zipOut);
                ++n2;
            }
        } else {
            FileUtil.zipFile(fileToZip, fileToZip.getName(), zipOut);
        }
        zipOut.close();
        fos.close();
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            if (!((String)fileName).endsWith("/") && !((String)fileName).isEmpty()) {
                fileName = (String)fileName + "/";
            }
            zipOut.putNextEntry(new ZipEntry((String)fileName));
            zipOut.closeEntry();
            File[] fileArray = children = fileToZip.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                FileUtil.zipFile(childFile, (String)fileName + childFile.getName(), zipOut);
                ++n2;
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry((String)fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        FileUtil.createDir(new File(filePath).getParentFile());
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    public static File correctFile(File file) {
        return FileUtil.findFileIgnoreCase(file, file);
    }

    public static File findFileIgnoreCase(File file, File defaultFile) {
        File[] files;
        File dir;
        if (file == null) {
            return defaultFile;
        }
        if (file.exists()) {
            return file;
        }
        if (!SystemUtil.isWindows() && (dir = FileUtil.correctFile(file.getParentFile())) != null && dir.exists() && (files = dir.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getAbsolutePath().equalsIgnoreCase(file.getAbsolutePath())) {
                    return f;
                }
                ++n2;
            }
        }
        return defaultFile;
    }

    public static String replaceInvalidFileCharacters(String path, String replacement) {
        return path.replaceAll("[^\\w\\-.]", replacement);
    }

    static class Result {
        public boolean mResult = false;

        Result() {
        }
    }
}

