/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.file;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class FolderComparator {
    List<BiFunction<Path, Path, Boolean>> compareFunctions = new ArrayList<BiFunction<Path, Path, Boolean>>();
    List<String> filterExtension = new ArrayList<String>();

    public boolean directoryContentEquals(Path dir1, Path dir2) throws IOException {
        boolean dir2Exists;
        boolean dir1Exists = Files.exists(dir1, new LinkOption[0]) && Files.isDirectory(dir1, new LinkOption[0]);
        boolean bl = dir2Exists = Files.exists(dir2, new LinkOption[0]) && Files.isDirectory(dir2, new LinkOption[0]);
        if (dir1Exists && dir2Exists) {
            HashMap<Path, Path> dir1Paths = new HashMap<Path, Path>();
            HashMap<Path, Path> dir2Paths = new HashMap<Path, Path>();
            for (Path path : this.listPaths(dir1, this.filterExtension)) {
                dir1Paths.put(dir1.relativize(path), path);
            }
            for (Path path : this.listPaths(dir2, this.filterExtension)) {
                dir2Paths.put(dir2.relativize(path), path);
            }
            if (dir1Paths.size() != dir2Paths.size()) {
                return false;
            }
            for (Map.Entry entry : dir1Paths.entrySet()) {
                Path relativePath = (Path)entry.getKey();
                Path absolutePath = (Path)entry.getValue();
                if (!dir2Paths.containsKey(relativePath)) {
                    return false;
                }
                if (this.contentEquals(absolutePath, (Path)dir2Paths.get(relativePath))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List<Path> listPaths(Path file, List<String> extensions) throws IOException {
        if (file == null) {
            return null;
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        this.listPaths(file, paths, extensions);
        return paths;
    }

    private void listPaths(Path path, List<Path> result, List<String> extensions) throws IOException {
        if (path == null) {
            return;
        }
        if (Files.isReadable(path)) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
                for (Path p : directoryStream) {
                    this.listPaths(p, result, extensions);
                }
                directoryStream.close();
            } else {
                String filename = path.getFileName().toString();
                if (extensions.size() == 0) {
                    result.add(path);
                } else {
                    for (String extension : extensions) {
                        if (!filename.toLowerCase().endsWith(extension)) continue;
                        result.add(path);
                        break;
                    }
                }
            }
        }
    }

    private boolean contentEquals(Path p1, Path p2) throws IOException {
        if (!Files.exists(p1, new LinkOption[0]) || !Files.exists(p2, new LinkOption[0])) {
            return false;
        }
        if (Files.isDirectory(p1, new LinkOption[0]) && Files.isDirectory(p2, new LinkOption[0])) {
            return this.directoryContentEquals(p1, p2);
        }
        if (p1.equals(p2)) {
            return true;
        }
        boolean fileEquals = true;
        for (BiFunction<Path, Path, Boolean> f : this.compareFunctions) {
            boolean bl = fileEquals = fileEquals && f.apply(p1, p2) != false;
        }
        return fileEquals;
    }

    public void addCompareFunctions(BiFunction<Path, Path, Boolean> compareFunction) {
        this.compareFunctions.add(compareFunction);
    }

    public void addFilterExtension(String extension) {
        this.filterExtension.add(extension);
    }

    public void addFilterExtension(List<String> extensions) {
        this.filterExtension.addAll(extensions);
    }
}

