/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.math;

import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;
import net.edgemind.ibee.util.math.Point2D;

@JsType(namespace="ui")
public class Frame {
    private double x = 0.0;
    private double y = 0.0;
    private double width = 0.0;
    private double height = 0.0;
    private boolean mInvalid = false;

    @JsIgnore
    public Frame() {
        this.setInvalid(true);
    }

    public Frame(double x, double y, double width, double height) {
        if (width < 0.0) {
            this.setX(x + width);
        } else {
            this.setX(x);
        }
        if (height < 0.0) {
            this.setY(y + height);
        } else {
            this.setY(y);
        }
        this.setWidth(Math.abs(width));
        this.setHeight(Math.abs(height));
        this.setInvalid(false);
    }

    public void copy(Frame fromOther) {
        this.setX(fromOther.getX());
        this.setY(fromOther.getY());
        this.setWidth(fromOther.getWidth());
        this.setHeight(fromOther.getHeight());
        this.setInvalid(fromOther.isInvalid());
    }

    public void expand(Frame other) {
        if (other.isInvalid()) {
            return;
        }
        if (this.isInvalid()) {
            this.copy(other);
            return;
        }
        if (other.getX() < this.getX()) {
            this.setWidth(this.getWidth() + (this.getX() - other.getX()));
            this.setX(other.getX());
        }
        if (other.getY() < this.getY()) {
            this.setHeight(this.getHeight() + (this.getY() - other.getY()));
            this.setY(other.getY());
        }
        if (other.getX() + other.getWidth() > this.getX() + this.getWidth()) {
            this.setWidth(other.getX() + other.getWidth() - this.getX());
        }
        if (other.getY() + other.getHeight() > this.getY() + this.getHeight()) {
            this.setHeight(other.getY() + other.getHeight() - this.getY());
        }
    }

    public void limit(Frame other) {
        if (other.isInvalid()) {
            return;
        }
        if (this.isInvalid()) {
            this.copy(other);
            return;
        }
        if (other.getX() > this.getX()) {
            this.setWidth(this.getWidth() - (other.getX() - this.getX()));
            this.setX(other.getX());
        }
        if (other.getY() > this.getY()) {
            this.setHeight(this.getHeight() - (other.getY() - this.getY()));
            this.setY(other.getY());
        }
        if (other.getX() + other.getWidth() < this.getX() + this.getWidth()) {
            this.setWidth(other.getX() + other.getWidth() - this.getX());
        }
        if (other.getY() + other.getHeight() < this.getY() + this.getHeight()) {
            this.setHeight(other.getY() + other.getHeight() - this.getY());
        }
    }

    public void reset() {
        this.setX(0.0);
        this.setY(0.0);
        this.setWidth(0.0);
        this.setHeight(0.0);
        this.setInvalid(true);
    }

    public void smoothFrame() {
        this.setX(Math.floor(this.getX()));
        this.setY(Math.floor(this.getY()));
        this.setWidth(Math.floor(this.getWidth()));
        this.setHeight(Math.floor(this.getHeight()));
    }

    public boolean contains(Point2D p) {
        if (p.getX() < this.getX() || p.getX() > this.getX() + this.getWidth()) {
            return false;
        }
        return !(p.getY() < this.getY()) && !(p.getY() > this.getY() + this.getHeight());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setX(double x) {
        this.setInvalid(false);
        this.x = x;
    }

    public void setY(double y) {
        this.setInvalid(false);
        this.y = y;
    }

    public void setWidth(double width) {
        this.setInvalid(false);
        this.width = width;
    }

    public void setHeight(double height) {
        this.setInvalid(false);
        this.height = height;
    }

    public Point2D getCenter() {
        return new Point2D(this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight() / 2.0);
    }

    public Point2D getNorth() {
        return new Point2D(this.getX() + this.getWidth() / 2.0, this.getY());
    }

    public Point2D getSouth() {
        return new Point2D(this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight());
    }

    public Point2D getWest() {
        return new Point2D(this.getX(), this.getY() + this.getHeight() / 2.0);
    }

    public Point2D getEast() {
        return new Point2D(this.getX() + this.getWidth(), this.getY() + this.getHeight() / 2.0);
    }

    public Point2D getNorthWest() {
        return new Point2D(this.getX(), this.getY());
    }

    public Point2D getNorthEast() {
        return new Point2D(this.getX() + this.getWidth(), this.getY());
    }

    public Point2D getSouthWest() {
        return new Point2D(this.getX(), this.getY() + this.getHeight());
    }

    public Point2D getSouthEast() {
        return new Point2D(this.getX() + this.getWidth(), this.getY() + this.getHeight());
    }

    public Point2D getPoint(AnchorPoint anchor) {
        switch (anchor) {
            case North: {
                return this.getNorth();
            }
            case East: {
                return this.getEast();
            }
            case West: {
                return this.getWest();
            }
            case South: {
                return this.getSouth();
            }
            case NorthEast: {
                return this.getNorthEast();
            }
            case SouthEast: {
                return this.getSouthEast();
            }
            case NorthWest: {
                return this.getNorthWest();
            }
            case SouthWest: {
                return this.getSouthWest();
            }
            case Center: {
                return this.getCenter();
            }
        }
        return null;
    }

    public boolean isInvalid() {
        return this.mInvalid;
    }

    public void setInvalid(boolean mInvalid) {
        this.mInvalid = mInvalid;
    }

    public static enum AnchorPoint {
        Center,
        North,
        East,
        South,
        West,
        NorthWest,
        SouthWest,
        NorthEast,
        SouthEast;

    }
}

