/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.math;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.util.math.Frame;

public class FrameUtil {
    public static List<Frame> combineArea(List<Frame> frames) {
        List<Frame> framesCombined = new ArrayList<Frame>();
        for (Frame frame : frames) {
            framesCombined = FrameUtil.combineArea(framesCombined, frame);
        }
        return framesCombined;
    }

    public static List<Frame> combineArea(List<Frame> disjunktFrames, Frame newFrame) {
        ArrayList<Frame> framesCombined = new ArrayList<Frame>();
        for (Frame frame : disjunktFrames) {
            framesCombined.addAll(FrameUtil.cutArea(frame, newFrame));
        }
        framesCombined.add(newFrame);
        return framesCombined;
    }

    public static List<Frame> combineArea(Frame frame1, Frame frame2) {
        List<Frame> framesCombined = FrameUtil.cutArea(frame1, frame2);
        framesCombined.add(frame2);
        return framesCombined;
    }

    public static List<Frame> cutArea(Frame frame, Frame areaToCut) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        Frame fLeft = new Frame();
        fLeft.setX(frame.getX());
        fLeft.setY(frame.getY());
        fLeft.setWidth(Math.min(frame.getX() + frame.getWidth(), areaToCut.getX()) - fLeft.getX());
        fLeft.setHeight(frame.getHeight());
        if (fLeft.getWidth() > 0.0 && fLeft.getHeight() > 0.0) {
            frames.add(fLeft);
        }
        Frame fRight = new Frame();
        fRight.setX(Math.max(frame.getX(), areaToCut.getX() + areaToCut.getWidth()));
        fRight.setY(frame.getY());
        fRight.setWidth(frame.getX() + frame.getWidth() - fRight.getX());
        fRight.setHeight(frame.getHeight());
        if (fRight.getWidth() > 0.0 && fRight.getHeight() > 0.0) {
            frames.add(fRight);
        }
        Frame fUpper = new Frame();
        fUpper.setX(Math.max(frame.getX(), areaToCut.getX()));
        fUpper.setY(frame.getY());
        fUpper.setWidth(Math.min(frame.getX() + frame.getWidth(), areaToCut.getX() + areaToCut.getWidth()) - fUpper.getX());
        fUpper.setHeight(Math.min(frame.getY() + frame.getHeight(), areaToCut.getY()) - fUpper.getY());
        if (fUpper.getWidth() > 0.0 && fUpper.getHeight() > 0.0) {
            frames.add(fUpper);
        }
        Frame fDown = new Frame();
        fDown.setX(Math.max(frame.getX(), areaToCut.getX()));
        fDown.setY(Math.max(areaToCut.getY() + areaToCut.getHeight(), frame.getY()));
        fDown.setWidth(Math.min(frame.getX() + frame.getWidth(), areaToCut.getX() + areaToCut.getWidth()) - fDown.getX());
        fDown.setHeight(frame.getY() + frame.getHeight() - fDown.getY());
        if (fDown.getWidth() > 0.0 && fDown.getHeight() > 0.0) {
            frames.add(fDown);
        }
        return frames;
    }

    public static boolean intersect(Frame frame1, Frame frame2) {
        return frame1.getX() < frame2.getX() + frame2.getWidth() && frame1.getX() + frame1.getWidth() > frame2.getX() && frame1.getY() < frame2.getY() + frame2.getHeight() && frame1.getY() + frame1.getHeight() > frame2.getY();
    }

    public static boolean isInside(Frame frame, double x, double y) {
        return x > frame.getX() && x < frame.getX() + frame.getWidth() && y > frame.getY() && y < frame.getY() + frame.getHeight();
    }
}

