/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.string;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternUtil {
    public static Pattern createPattern(String patternS) {
        Pattern pattern = null;
        if (patternS.startsWith("/")) {
            try {
                pattern = Pattern.compile(patternS.substring(1), 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                pattern = null;
            }
        } else if (patternS.trim().equals("")) {
            pattern = Pattern.compile("");
        } else {
            patternS = patternS.replaceAll("\\*", "[\\\\w]*");
            pattern = null;
        }
        return pattern;
    }

    public static boolean validateExpr(String expr, Pattern pattern, String start) {
        if (pattern != null) {
            return pattern.matcher(expr).find();
        }
        return PatternUtil.wildCardMatch(expr.toLowerCase(), start);
    }

    public static boolean wildCardMatch(String text, String pattern) {
        if (pattern.isEmpty()) {
            return true;
        }
        if (text == null) {
            text = "";
        }
        text = text.toLowerCase();
        if (!(pattern = pattern.toLowerCase()).contains("*")) {
            return text.startsWith(pattern);
        }
        String[] cards = pattern.split("\\*");
        boolean first = true;
        String[] stringArray = cards;
        int n = cards.length;
        int n2 = 0;
        while (n2 < n) {
            int idx;
            String card = stringArray[n2];
            if (first) {
                first = false;
                if (!text.startsWith(card)) {
                    return false;
                }
            }
            if ((idx = text.indexOf(card)) == -1) {
                return false;
            }
            text = text.substring(idx + card.length());
            ++n2;
        }
        return true;
    }

    public static boolean wildCardMatchTotal(String text, String pattern) {
        if (text == null) {
            text = "";
        }
        text = text.toLowerCase();
        String[] cards = pattern.toLowerCase().split("\\*");
        boolean first = true;
        String[] stringArray = cards;
        int n = cards.length;
        int n2 = 0;
        while (n2 < n) {
            int idx;
            String card = stringArray[n2];
            if (first) {
                first = false;
                if (!text.startsWith(card)) {
                    return false;
                }
            }
            if ((idx = text.indexOf(card)) == -1) {
                return false;
            }
            text = text.substring(idx + card.length());
            ++n2;
        }
        if (pattern.endsWith("*")) {
            return true;
        }
        return text.length() == 0;
    }
}

