/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.util.xml;

import net.edgemind.ibee.util.xml.DomElement;

public class DomUtil {
    public String getAsText(DomElement e) {
        StringBuffer buf = new StringBuffer();
        this.convert(e, buf);
        return buf.toString();
    }

    private void convert(DomElement e, StringBuffer buf) {
        boolean hasText;
        buf.append("<" + e.name);
        if (e.attributes.size() > 0) {
            for (String attr : e.attributes.keySet()) {
                buf.append(" " + attr + "=\"" + e.attributes.get(attr) + "\"");
            }
        }
        boolean hasChildren = e.children.size() > 0;
        boolean bl = hasText = e.text() != null && e.text().length() > 0;
        if (hasChildren || hasText) {
            buf.append(">");
            if (hasChildren) {
                for (DomElement child : e.children) {
                    this.convert(child, buf);
                }
            }
            if (hasText) {
                buf.append(e.text());
            }
            buf.append("</" + e.name + ">");
        } else {
            buf.append("/>");
        }
    }
}

